/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import wf.utils.bukkit.world.WorldUtils;
import wf.utils.java.math.MathUtils;

public class EntityUtils {
    public static Collection<LivingEntity> getEntityInRadius(Player player, double x, double y, boolean removeThis) {
        Collection entities = player.getWorld().getNearbyLivingEntities(player.getLocation(), x, y);
        if (removeThis) {
            entities.remove(player);
        }
        return entities;
    }

    public static Collection<LivingEntity> getEntityInCube(Player player, double x, double y, double z, boolean removeThis) {
        Collection entities = player.getWorld().getNearbyLivingEntities(player.getLocation(), x, y, z);
        if (removeThis) {
            entities.remove(player);
        }
        return entities;
    }

    public static Collection<LivingEntity> getLivingInRadius(Location location, double x, double y) {
        return location.getWorld().getNearbyLivingEntities(location, x, y);
    }

    public static Collection<LivingEntity> getLivingEntityInCube(Location location, double x, double y, double z) {
        return location.getWorld().getNearbyLivingEntities(location, x, y, z);
    }

    public static Collection<Entity> getEntityInCube(Location location, double x, double y, double z) {
        return location.getWorld().getNearbyEntities(location, x, y, z);
    }

    public static int getEntityAgreedEntitiesCount(LivingEntity entity) {
        int count = 0;
        for (LivingEntity e : entity.getWorld().getLivingEntities()) {
            Mob mob;
            if (!(e instanceof Mob) || (mob = (Mob)e).getTarget().equals(entity)) continue;
            ++count;
        }
        return count;
    }

    public static ArrayList<LivingEntity> getEntityAgreedEntities(LivingEntity entity) {
        ArrayList<LivingEntity> agreedEntities = new ArrayList<LivingEntity>();
        for (LivingEntity e : entity.getWorld().getLivingEntities()) {
            Mob mob;
            if (!(e instanceof Mob) || (mob = (Mob)e).getTarget().equals(entity)) continue;
            agreedEntities.add((LivingEntity)mob);
        }
        return agreedEntities;
    }

    public static void addEffect(LivingEntity entity, PotionEffect effect) {
        entity.addPotionEffect(effect, true);
    }

    public static void addEffect(Collection<LivingEntity> entities, PotionEffect effect) {
        entities.forEach(e -> EntityUtils.addEffect(e, effect));
    }

    public static void damage(LivingEntity entity, double damage, boolean netDamage) {
        if (netDamage) {
            entity.damage(0.0);
            float health = (float)(entity.getHealth() - damage);
            entity.setHealth(health < 0.0f ? 0.0 : (double)health);
        } else {
            entity.damage(damage);
        }
    }

    public static void damage(Collection<LivingEntity> entities, double damage, boolean netDamage) {
        entities.forEach(e -> EntityUtils.damage(e, damage, netDamage));
    }

    public static void fireTicks(LivingEntity entity, int fireTicks) {
        entity.setFireTicks(fireTicks);
    }

    public static void fireTicks(Player player, Collection<LivingEntity> entities, int fireTicks) {
        entities.forEach(e -> EntityUtils.fireTicks(e, fireTicks));
    }

    public static boolean entityIsInCube(Location l1, Location l2, Entity entity) {
        return WorldUtils.locationInLocations(l1, l2, entity.getLocation());
    }

    public static void removeEntityIf(Function<Entity, Boolean> condition) {
        for (World world : Bukkit.getWorlds()) {
            EntityUtils.removeEntityIf(condition, world);
        }
    }

    public static void removeLivingEntityIf(Function<LivingEntity, Boolean> condition) {
        for (World world : Bukkit.getWorlds()) {
            EntityUtils.removeLivingEntityIf(condition, world);
        }
    }

    public static void removeEntityByClassIf(Function<Entity, Boolean> condition, Class<?> cl) {
        for (World world : Bukkit.getWorlds()) {
            EntityUtils.removeEntityByClassIf(condition, cl, world);
        }
    }

    public static void removeEntityByClassIf(Function<Entity, Boolean> condition, Class<?> cl, World world) {
        for (Entity entity : world.getEntitiesByClasses(new Class[]{cl})) {
            if (!condition.apply(entity).booleanValue()) continue;
            entity.remove();
        }
    }

    public static void removeEntityIf(Function<Entity, Boolean> condition, World world) {
        for (Entity entity : world.getEntities()) {
            if (!condition.apply(entity).booleanValue()) continue;
            entity.remove();
        }
    }

    public static void removeLivingEntityIf(Function<LivingEntity, Boolean> condition, World world) {
        for (LivingEntity entity : world.getLivingEntities()) {
            if (!condition.apply(entity).booleanValue()) continue;
            entity.remove();
        }
    }

    public static void removeEntityInCube(Function<Entity, Boolean> condition, Location l, double w, double h) {
        for (Entity entity : EntityUtils.getEntityInCube(l, w, h, w)) {
            if (!condition.apply(entity).booleanValue()) continue;
            entity.remove();
        }
    }

    public static void lookAt(Entity entity, Location location) {
        entity.teleport(entity.getLocation().setDirection(EntityUtils.getLookAtVector(entity.getLocation(), location)));
    }

    public static Vector getLookAtVector(Location at, Location to) {
        double dx = to.getX() - at.getX();
        double dy = to.getY() - at.getY() - 1.5;
        double dz = to.getZ() - at.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        float pitch = (float)Math.toDegrees(Math.atan2(Math.sqrt(dx * dx + dz * dz), dy)) - 90.0f;
        return new Vector(Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)), Math.sin(Math.toRadians(pitch)), Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public static double getYawSideAngle(Location at, Location to) {
        return MathUtils.roundToNearestNumber(at.clone().setDirection(EntityUtils.getLookAtVector(at, to)).getYaw() + 90.0f, 90.0);
    }

    public static double getPitchSideAngle(Location at, Location to) {
        return MathUtils.roundToNearestNumber(at.clone().setDirection(EntityUtils.getLookAtVector(at, to)).getPitch(), 90.0);
    }

    public static void setYawSideAngle(Entity entity, Location to) {
        EntityUtils.setYaw(entity, (float)MathUtils.roundToNearestNumber(entity.getLocation().clone().setDirection(EntityUtils.getLookAtVector(entity.getLocation(), to)).getYaw() + 90.0f, 90.0));
    }

    public static void setPitchSideAngle(Entity entity, Location to) {
        EntityUtils.setPitch(entity, (float)MathUtils.roundToNearestNumber(entity.getLocation().clone().setDirection(EntityUtils.getLookAtVector(entity.getLocation(), to)).getPitch(), 90.0));
    }

    public static void setRotationSideAngle(Entity entity, Location to) {
        EntityUtils.setYawSideAngle(entity, to);
        EntityUtils.setPitchSideAngle(entity, to);
    }

    public static void setYaw(Entity entity, float yaw) {
        Location location = entity.getLocation();
        location.setYaw(yaw);
        entity.teleport(location);
    }

    public static void setPitch(Entity entity, float pitch) {
        Location location = entity.getLocation();
        location.setPitch(pitch);
        entity.teleport(location);
    }

    public static void setRotation(Entity entity, float yaw, float pitch) {
        Location location = entity.getLocation();
        location.setYaw(yaw);
        location.setPitch(pitch);
        entity.teleport(location);
    }
}

