/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.inventory.gui;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.inventory.gui.item.Item;
import wf.utils.bukkit.inventory.gui.item.ItemSlot;

public class BukkitGui {
    private String name;
    private String displayName;
    private Plugin plugin;
    private int size = 27;
    private InventoryType type = InventoryType.CHEST;
    private ItemSlot[] slots;

    public BukkitGui() {
    }

    public BukkitGui(Plugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public Inventory getInventory(Player player) {
        Inventory inv = this.createEmptyInventory();
        for (ItemSlot slot : this.slots) {
            Item item = slot.getItem();
            if (!item.isCondition(player, null)) continue;
            ItemStack itemStack = item.getReplacedItemStack(player, null);
            inv.setItem(slot.getIndex(), itemStack);
        }
        return inv;
    }

    public Inventory createEmptyInventory() {
        if (this.type == InventoryType.CHEST) {
            return Bukkit.createInventory(null, (int)this.size, (String)(this.displayName == null ? this.type.getDefaultTitle() : this.displayName));
        }
        return Bukkit.createInventory(null, (InventoryType)this.type, (String)(this.displayName == null ? this.type.getDefaultTitle() : this.displayName));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public InventoryType getType() {
        return this.type;
    }

    public void setType(InventoryType type) {
        this.type = type;
    }

    public ItemSlot[] getSlots() {
        return this.slots;
    }

    public void setSlots(ItemSlot[] slots) {
        this.slots = slots;
    }
}

