/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.inventory.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.config.BukkitConfig;
import wf.utils.bukkit.data.PersistDataUtils;
import wf.utils.bukkit.inventory.gui.BukkitGui;
import wf.utils.bukkit.inventory.gui.EntityBukkitGui;
import wf.utils.bukkit.inventory.gui.ListedBukkitGui;
import wf.utils.bukkit.inventory.gui.item.Condition;
import wf.utils.bukkit.inventory.gui.item.Function;
import wf.utils.bukkit.inventory.gui.item.Item;
import wf.utils.bukkit.inventory.gui.item.ItemCondition;
import wf.utils.bukkit.inventory.gui.item.ItemFunction;
import wf.utils.bukkit.inventory.gui.item.ItemList;
import wf.utils.bukkit.inventory.gui.item.ItemReplacer;
import wf.utils.bukkit.inventory.gui.item.ItemSlot;
import wf.utils.bukkit.misc.chat_color.ListColored;

public class BukkitGuiController
implements Listener {
    private final Plugin plugin;
    private final BukkitConfig config;
    private HashMap<String, BukkitGui> guis = new HashMap();
    private HashMap<String, Item> items = new HashMap();
    private HashMap<String, Function> functions = new HashMap();
    private HashMap<String, Condition> conditions = new HashMap();
    private HashMap<String, ItemReplacer> replaces = new HashMap();
    private HashMap<String, ItemList> itemLists = new HashMap();

    public BukkitGuiController(Plugin plugin, String configName) {
        this.plugin = plugin;
        this.config = new BukkitConfig(plugin, configName);
        this.addDefaultFunctions();
        this.addDefaultReplaces();
        this.addDefaultConditions();
    }

    public void load() {
        this.loadItems();
        this.loadGuis();
        this.registerListeners();
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!PersistDataUtils.hasString(this.plugin, "WF_BUKKIT_GUI_ITEM_NAME", itemStack)) {
            return;
        }
        event.setCancelled(true);
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String name = PersistDataUtils.getString(this.plugin, "WF_BUKKIT_GUI_ITEM_NAME", itemStack);
            Item item = this.items.get(name);
            if (PersistDataUtils.hasString(this.getPlugin(), "ENTITY", itemStack)) {
                arguments.put("entity", PersistDataUtils.getString(this.getPlugin(), "ENTITY", itemStack));
            }
            if (PersistDataUtils.hasString(this.getPlugin(), "PAGE", itemStack)) {
                arguments.put("page", PersistDataUtils.getString(this.getPlugin(), "PAGE", itemStack));
            }
            if (PersistDataUtils.hasString(this.getPlugin(), "GUI", itemStack)) {
                arguments.put("gui", PersistDataUtils.getString(this.getPlugin(), "GUI", itemStack));
            }
            item.applyFunctions(player, arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadItems() {
        this.config.forEach("items", s -> {
            Item item = new Item();
            item.setName((String)s);
            ItemStack itemStack = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)this.config.getString("items." + s + ".item.material"))));
            ItemMeta meta = itemStack.getItemMeta();
            if (this.config.contains("items." + s + ".item.name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("items." + s + ".item.name")));
            }
            if (this.config.contains("items." + s + ".item.lore")) {
                meta.setLore(ListColored.translate('&', this.config.getStringList("items." + s + ".item.lore")));
            }
            if (this.config.contains("items." + s + ".item.model_data")) {
                meta.setCustomModelData(Integer.valueOf(this.config.getInt("items." + s + ".item.model_data")));
            }
            itemStack.setItemMeta(meta);
            item.setItemStack(itemStack, this.plugin);
            item.setReplaceDisplayName(this.config.getBoolean("items." + s + ".replace_name", false));
            item.setReplaceLore(this.config.getBoolean("items." + s + ".replace_lore", false));
            item.setReplaceFunction(this.config.getBoolean("items." + s + ".replace_function", false));
            ArrayList itemFunctions = new ArrayList();
            if (this.config.contains("items." + s + ".functions")) {
                this.config.forEach("items." + s + ".functions", f -> {
                    ItemFunction function = new ItemFunction();
                    function.setName((String)f);
                    function.setFunction(this.functions.get(f));
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    this.config.forEach("items." + s + ".functions." + f, a -> arguments.put((String)a, this.config.getString("items." + s + ".functions." + f + "." + a)));
                    function.setArguments(arguments);
                    itemFunctions.add(function);
                });
            }
            item.setFunctions(itemFunctions.toArray(new ItemFunction[0]));
            ArrayList<ItemReplacer> itemReplaces = new ArrayList<ItemReplacer>();
            if (this.config.contains("items." + s + ".replaces")) {
                for (String r : this.config.getStringList("items." + s + ".replaces")) {
                    itemReplaces.add(this.replaces.get(r));
                }
            }
            item.setReplaces(itemReplaces.toArray(new ItemReplacer[0]));
            ArrayList itemConditions = new ArrayList();
            if (this.config.contains("items." + s + ".conditions")) {
                this.config.getStringList("items." + s + ".conditions").forEach(f -> {
                    ItemCondition condition = new ItemCondition();
                    condition.setName((String)f);
                    condition.setCondition(this.conditions.get(f));
                    itemConditions.add(condition);
                });
            }
            item.setConditions(itemConditions.toArray(new ItemCondition[0]));
            this.items.put((String)s, item);
        });
    }

    private void loadGuis() {
        this.config.forEach("guis", g -> {
            BukkitGui gui;
            String guiType = this.config.getString("guis." + g + ".gui_type", "default");
            if (this.guis.containsKey(g)) {
                gui = this.guis.get(g);
            } else {
                gui = guiType.equalsIgnoreCase("listed") ? new ListedBukkitGui(null, null, this.config.getInt("guis." + g + ".start_index", 0), this.config.getInt("guis." + g + ".count", 9), this.items.get(this.config.getString("guis." + g + ".list_item")), this.itemLists.get(this.config.getString("guis." + g + ".list"))) : (guiType.equalsIgnoreCase("entity") ? new EntityBukkitGui() : new BukkitGui());
                this.guis.put((String)g, gui);
            }
            gui.setPlugin(this.plugin);
            gui.setName((String)g);
            if (this.config.contains("guis." + g + ".size")) {
                gui.setSize(this.config.getInt("guis." + g + ".size"));
            }
            if (this.config.contains("guis." + g + ".type")) {
                gui.setType(InventoryType.valueOf((String)this.config.getString("guis." + g + ".type")));
            }
            if (this.config.contains("guis." + g + ".display_name")) {
                gui.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("guis." + g + ".display_name")));
            }
            if (this.config.contains("guis." + g + ".inventory_type")) {
                gui.setType(InventoryType.valueOf((String)this.config.getString("guis." + g + ".inventory_type")));
            }
            if (this.config.contains("guis." + g + ".items")) {
                ArrayList itemSlots = new ArrayList();
                this.config.forEach("guis." + g + ".items", i -> {
                    ItemSlot itemSlot = new ItemSlot();
                    itemSlot.setItem(this.items.get(this.config.getString("guis." + g + ".items." + i + ".name")));
                    itemSlot.setIndex(this.config.getInt("guis." + g + ".items." + i + ".slot"));
                    itemSlots.add(itemSlot);
                });
                gui.setSlots(itemSlots.toArray(new ItemSlot[0]));
            }
        });
    }

    private void addDefaultFunctions() {
        this.functions.put("open_gui", new Function((p, m) -> {
            if (m == null) {
                return;
            }
            if (!m.containsKey("gui")) {
                return;
            }
            if (!this.guis.containsKey(m.get("gui"))) {
                return;
            }
            p.openInventory(this.guis.get(m.get("gui")).getInventory((Player)p));
        }));
        this.functions.put("open_entity_gui", new Function((p, m) -> {
            if (m == null) {
                return;
            }
            if (!m.containsKey("gui")) {
                return;
            }
            if (!m.containsKey("entity")) {
                return;
            }
            BukkitGui gui = this.guis.get(m.get("gui"));
            if (gui == null) {
                return;
            }
            if (!(gui instanceof EntityBukkitGui)) {
                return;
            }
            p.openInventory(((EntityBukkitGui)gui).getInventory((Player)p, (String)m.get("entity")));
        }));
        this.functions.put("next_page", new Function((p, m) -> {
            if (m == null) {
                return;
            }
            if (!m.containsKey("gui")) {
                return;
            }
            if (!m.containsKey("page")) {
                return;
            }
            BukkitGui gui = this.guis.get(m.get("gui"));
            if (gui == null) {
                return;
            }
            if (!(gui instanceof ListedBukkitGui)) {
                return;
            }
            p.openInventory(((ListedBukkitGui)gui).getInventory((Player)p, Integer.parseInt((String)m.get("page")) + 1));
        }));
        this.functions.put("prev_page", new Function((p, m) -> {
            if (m == null) {
                return;
            }
            if (!m.containsKey("gui")) {
                return;
            }
            if (!m.containsKey("page")) {
                return;
            }
            BukkitGui gui = this.guis.get(m.get("gui"));
            if (gui == null) {
                return;
            }
            if (!(gui instanceof ListedBukkitGui)) {
                return;
            }
            p.openInventory(((ListedBukkitGui)gui).getInventory((Player)p, Integer.parseInt((String)m.get("page")) - 1));
        }));
        this.functions.put("run_command", new Function((p, m) -> {
            if (m == null) {
                return;
            }
            if (!m.containsKey("command")) {
                return;
            }
            Bukkit.getServer().dispatchCommand((CommandSender)p, (String)m.get("command"));
        }));
        this.functions.put("close_gui", new Function((p, m) -> p.closeInventory()));
    }

    private void addDefaultReplaces() {
        this.replaces.put("{player_name}", new ItemReplacer("{player_name}", (p, m) -> p.getName()));
        this.replaces.put("{player_display_name}", new ItemReplacer("{player_display_name}", (p, m) -> p.getDisplayName()));
        this.replaces.put("{player_uuid}", new ItemReplacer("{player_uuid}", (p, m) -> p.getUniqueId().toString()));
        this.replaces.put("{entity}", new ItemReplacer("{entity}", (p, m) -> String.valueOf(m.get("entity"))));
    }

    private void addDefaultConditions() {
        this.conditions.put("has_next_page", new Condition((p, m) -> {
            String b = (String)m.get("has_next_page");
            if (b == null) {
                return false;
            }
            return Boolean.parseBoolean(b);
        }));
        this.conditions.put("has_prev_page", new Condition((p, m) -> {
            String b = (String)m.get("has_prev_page");
            if (b == null) {
                return false;
            }
            return Boolean.parseBoolean(b);
        }));
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BukkitConfig getConfig() {
        return this.config;
    }

    public HashMap<String, BukkitGui> getGuis() {
        return this.guis;
    }

    public void setGuis(HashMap<String, BukkitGui> guis) {
        this.guis = guis;
    }

    public HashMap<String, Item> getItems() {
        return this.items;
    }

    public void setItems(HashMap<String, Item> items) {
        this.items = items;
    }

    public HashMap<String, Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(HashMap<String, Function> functions) {
        this.functions = functions;
    }

    public HashMap<String, Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(HashMap<String, Condition> conditions) {
        this.conditions = conditions;
    }

    public HashMap<String, ItemReplacer> getReplaces() {
        return this.replaces;
    }

    public void setReplaces(HashMap<String, ItemReplacer> replaces) {
        this.replaces = replaces;
    }

    public HashMap<String, ItemList> getItemLists() {
        return this.itemLists;
    }

    public void setItemLists(HashMap<String, ItemList> itemLists) {
        this.itemLists = itemLists;
    }

    public String toString() {
        return "BukkitGuiController{plugin=" + this.plugin + ", config=" + this.config + ", guis=" + this.guis + ", items=" + this.items + ", functions=" + this.functions + ", conditions=" + this.conditions + ", replaces=" + this.replaces + ", itemLists=" + this.itemLists + "}";
    }
}

