/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.inventory.gui;

import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.data.PersistDataUtils;
import wf.utils.bukkit.inventory.gui.BukkitGui;
import wf.utils.bukkit.inventory.gui.item.Item;
import wf.utils.bukkit.inventory.gui.item.ItemList;
import wf.utils.bukkit.inventory.gui.item.ItemSlot;

public class ListedBukkitGui
extends BukkitGui {
    private int startIndex;
    private int maxOnPage;
    private Item listedItem;
    private ItemList list;

    public ListedBukkitGui() {
    }

    public ListedBukkitGui(int startIndex, int maxOnPage, Item listedItem, ItemList list) {
        this.startIndex = startIndex;
        this.maxOnPage = maxOnPage;
        this.listedItem = listedItem;
        this.list = list;
    }

    public ListedBukkitGui(Plugin plugin, String name, int startIndex, int maxOnPage, Item listedItem, ItemList list) {
        super(plugin, name);
        this.startIndex = startIndex;
        this.maxOnPage = maxOnPage;
        this.listedItem = listedItem;
        this.list = list;
    }

    @Override
    public Inventory getInventory(Player player) {
        return this.getInventory(player, 0);
    }

    public Inventory getInventory(Player player, int page) {
        int count;
        if (page < 0) {
            page = 0;
        }
        if (this.maxOnPage * page > (count = this.list.getCount(player, null))) {
            return this.getInventory(player, count / this.maxOnPage);
        }
        Inventory inv = this.createEmptyInventory();
        HashMap<String, String> arguments = new HashMap<String, String>(3);
        arguments.put("page", String.valueOf(page));
        arguments.put("has_next_page", String.valueOf(this.maxOnPage * (page + 1) < count));
        arguments.put("has_prev_page", String.valueOf(page != 0));
        for (ItemSlot slot : this.getSlots()) {
            Item item = slot.getItem();
            if (!item.isCondition(player, arguments)) continue;
            ItemStack itemStack = item.getReplacedItemStack(player, arguments);
            PersistDataUtils.set(this.getPlugin(), "PAGE", itemStack, String.valueOf(page));
            PersistDataUtils.set(this.getPlugin(), "GUI", itemStack, this.getName());
            inv.setItem(slot.getIndex(), itemStack);
        }
        int finalPage = page;
        new Thread(() -> {
            List<String> entities = this.list.get(player, null, finalPage * this.maxOnPage, Math.min((finalPage + 1) * this.maxOnPage - 1, count - 1));
            long start = System.currentTimeMillis();
            int i = 0;
            for (int slot = this.startIndex; i < entities.size() && slot < this.getSize(); ++i, ++slot) {
                if (inv.getItem(slot) != null) {
                    --i;
                    continue;
                }
                arguments.clear();
                arguments.put("entity", entities.get(i));
                if (this.listedItem.isCondition(player, arguments)) {
                    ItemStack itemStack = this.listedItem.getReplacedItemStackAsListedItem(player, arguments);
                    PersistDataUtils.set(this.getPlugin(), "ENTITY", itemStack, entities.get(i));
                    inv.setItem(slot, itemStack);
                }
                if (start + 1000L >= System.currentTimeMillis()) continue;
                if (inv.getViewers().isEmpty()) break;
                start = System.currentTimeMillis();
            }
        }).start();
        return inv;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getMaxOnPage() {
        return this.maxOnPage;
    }

    public void setMaxOnPage(int maxOnPage) {
        this.maxOnPage = maxOnPage;
    }

    public Item getListedItem() {
        return this.listedItem;
    }

    public void setListedItem(Item listedItem) {
        this.listedItem = listedItem;
    }

    public ItemList getList() {
        return this.list;
    }

    public void setList(ItemList list) {
        this.list = list;
    }

    public String toString() {
        return "ListedBukkitGui{startIndex=" + this.startIndex + ", maxOnPage=" + this.maxOnPage + ", listedItem=" + this.listedItem + ", list=" + this.list + "}";
    }
}

