/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.inventory.gui.item;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.data.PersistDataUtils;
import wf.utils.bukkit.inventory.gui.item.ItemCondition;
import wf.utils.bukkit.inventory.gui.item.ItemFunction;
import wf.utils.bukkit.inventory.gui.item.ItemReplacer;
import wf.utils.bukkit.inventory.gui.item.ItemReplacerUtils;
import wf.utils.bukkit.item.ItemUtils;

public class Item {
    private String name;
    private ItemStack itemStack;
    private boolean replaceDisplayName;
    private boolean replaceLore;
    private boolean replaceFunction;
    private ItemCondition[] conditions;
    private ItemFunction[] functions;
    private ItemReplacer[] replaces;

    public boolean isCondition(Player player, Map<String, String> arguments) {
        for (ItemCondition itemCondition : this.conditions) {
            if (itemCondition.getCondition().isCondited(player, arguments)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemStack getReplacedItemStack(Player player, HashMap<String, String> arguments) {
        ItemStack item = this.itemStack.clone();
        ItemMeta meta = item.getItemMeta();
        if (this.replaceDisplayName && meta.hasDisplayName()) {
            meta.setDisplayName(ItemReplacerUtils.replace(this.replaces, meta.getDisplayName(), player, arguments));
        }
        if (this.replaceLore && meta.hasLore()) {
            meta.setLore(ItemReplacerUtils.replace(this.replaces, meta.getLore(), player, arguments));
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getReplacedItemStackAsListedItem(Player player, HashMap<String, String> arguments) {
        ItemStack item = this.getReplacedItemStack(player, arguments);
        if (item.getType() != Material.PLAYER_HEAD) {
            return item;
        }
        if (!arguments.containsKey("entity")) {
            return item;
        }
        return ItemUtils.setHead(item, arguments.get("entity"));
    }

    public void setItemStack(ItemStack itemStack, Plugin plugin) {
        ItemStack cloned = itemStack.clone();
        PersistDataUtils.set(plugin, "WF_BUKKIT_GUI_ITEM_NAME", cloned, this.name);
        this.itemStack = cloned;
    }

    public void applyFunctions(Player player, HashMap<String, String> arguments) {
        if (this.replaceFunction) {
            for (ItemFunction function : this.functions) {
                function.replaceAndApply(player, this.replaces, arguments);
            }
        } else {
            for (ItemFunction function : this.functions) {
                function.apply(player, arguments);
            }
        }
    }

    public boolean isReplaceDisplayName() {
        return this.replaceDisplayName;
    }

    public void setReplaceDisplayName(boolean replaceDisplayName) {
        this.replaceDisplayName = replaceDisplayName;
    }

    public boolean isReplaceLore() {
        return this.replaceLore;
    }

    public void setReplaceLore(boolean replaceLore) {
        this.replaceLore = replaceLore;
    }

    public boolean isReplaceFunction() {
        return this.replaceFunction;
    }

    public void setReplaceFunction(boolean replaceFunction) {
        this.replaceFunction = replaceFunction;
    }

    public ItemCondition[] getConditions() {
        return this.conditions;
    }

    public void setConditions(ItemCondition[] conditions) {
        this.conditions = conditions;
    }

    public ItemFunction[] getFunctions() {
        return this.functions;
    }

    public void setFunctions(ItemFunction[] functions) {
        this.functions = functions;
    }

    public ItemReplacer[] getReplaces() {
        return this.replaces;
    }

    public void setReplaces(ItemReplacer[] replaces) {
        this.replaces = replaces;
    }
}

