/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.inventory.gui.item;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import wf.utils.bukkit.inventory.gui.item.Function;
import wf.utils.bukkit.inventory.gui.item.ItemReplacer;
import wf.utils.bukkit.inventory.gui.item.ItemReplacerUtils;

public class ItemFunction {
    private String name;
    private Function function;
    private Map<String, String> arguments;

    public ItemFunction() {
    }

    public ItemFunction(String name, Function function, HashMap<String, String> arguments) {
        this.name = name;
        this.function = function;
        this.arguments = arguments;
    }

    public void apply(Player player) {
        this.function.apply(player, this.arguments);
    }

    public void apply(Player player, HashMap<String, String> arguments) {
        arguments = (HashMap)arguments.clone();
        arguments.putAll(this.arguments);
        this.function.apply(player, arguments);
    }

    public void replaceAndApply(Player player, ItemReplacer[] replaces, HashMap<String, String> arguments) {
        arguments = (HashMap)arguments.clone();
        arguments.putAll(this.arguments);
        this.function.apply(player, ItemReplacerUtils.replace(replaces, arguments, player, (Map<String, String>)((HashMap)arguments.clone())));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setArguments(HashMap<String, String> arguments) {
        this.arguments = arguments;
    }

    public String toString() {
        return "ItemFunction{name='" + this.name + "', function=" + this.function + ", arguments=" + this.arguments + "}";
    }
}

