/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.misc.while_runnable;

import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import wf.utils.java.thread.loop.LoopTask;

public class BukkitLoopTask
implements LoopTask {
    private BukkitTask task;
    private Runnable runnable;
    private final Plugin plugin;
    private final long period;
    private final long delay;
    private final boolean sync;

    public BukkitLoopTask(Runnable runnable, Plugin plugin, long period, long delay, boolean sync) {
        this.plugin = plugin;
        this.period = period;
        this.delay = delay;
        this.sync = sync;
        this.runnable = runnable;
    }

    public void initTask() {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                BukkitLoopTask.this.runnable.run();
            }
        };
        this.task = this.sync ? bukkitRunnable.runTaskTimer(this.plugin, this.delay, this.period) : bukkitRunnable.runTaskTimerAsynchronously(this.plugin, this.delay, this.period);
    }

    @Override
    public void stop() {
        if (!this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    @Override
    public void start() {
        this.initTask();
    }

    protected void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public long getPeriod() {
        return this.period;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isSync() {
        return this.sync;
    }
}

