/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.plugins.vault;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultUtils {
    private Economy economy;

    public VaultUtils(Plugin plugin) {
        RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
    }

    public double getMoney(Player p) {
        return this.economy.getBalance((OfflinePlayer)p);
    }

    public void setMoney(Player p, double count) {
        this.economy.depositPlayer((OfflinePlayer)p, count);
    }

    public void addMoney(Player p, double count) {
        this.economy.withdrawPlayer((OfflinePlayer)p, -count);
    }

    public void removeMoney(Player p, double count) {
        this.economy.withdrawPlayer((OfflinePlayer)p, count);
    }

    public boolean containMoney(Player p, double count) {
        return this.getMoney(p) >= count;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void setEconomy(Economy economy) {
        this.economy = economy;
    }

    public String toString() {
        return "VaultUtils{economy=" + this.economy + "}";
    }
}

