/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.plugins.world_guard.region;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;

public class RegionUtils {
    public static ProtectedCuboidRegion createRegion(String name, org.bukkit.World w, Location p1, Location p2) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        ProtectedCuboidRegion rg = new ProtectedCuboidRegion(name, BlockVector3.at((double)p1.getX(), (double)p1.getY(), (double)p1.getZ()), BlockVector3.at((double)p2.getX(), (double)p2.getY(), (double)p2.getZ()));
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(world);
        regions.addRegion((ProtectedRegion)rg);
        return rg;
    }

    public static boolean containRegion(org.bukkit.World w, Location p1, Location p2) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        ProtectedCuboidRegion rg = new ProtectedCuboidRegion("WF_UTILS_CHECK_REGION", BlockVector3.at((double)p1.getX(), (double)p1.getY(), (double)p1.getZ()), BlockVector3.at((double)p2.getX(), (double)p2.getY(), (double)p2.getZ()));
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(world);
        ApplicableRegionSet set = regionManager.getApplicableRegions((ProtectedRegion)rg);
        return set.size() != 0;
    }

    public static boolean containRegion(org.bukkit.World w, String name) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(world);
        return regionManager.getRegion(name) != null;
    }

    public static void deleteRegion(org.bukkit.World w, String name) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(world);
        regions.removeRegion(name);
    }

    public static void deleteRegions(org.bukkit.World w) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(world);
        for (ProtectedRegion region : regions.getRegions().values().toArray(new ProtectedRegion[0])) {
            regions.removeRegion(region.getId());
        }
    }

    public static ProtectedRegion getRegion(org.bukkit.World w, String name) {
        World world = BukkitAdapter.adapt((org.bukkit.World)w);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(world);
        return regionManager.getRegion(name);
    }

    public static void addMember(ProtectedRegion rg, UUID player) {
        rg.getMembers().addPlayer(player);
    }

    public static void removeMember(ProtectedRegion rg, UUID player) {
        rg.getMembers().removePlayer(player);
    }

    public static boolean containMember(ProtectedRegion rg, UUID player) {
        return rg.getMembers().contains(player);
    }

    public static List<ProtectedRegion> getRegions(Location location) {
        return new ArrayList<ProtectedRegion>(WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)new BukkitWorld(location.getWorld())).getApplicableRegions(BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ())).getRegions());
    }
}

