/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers;

public class Polybius {
    private static final char[][] key = new char[][]{{'A', 'B', 'C', 'D', 'E'}, {'F', 'G', 'H', 'I', 'J'}, {'K', 'L', 'M', 'N', 'O'}, {'P', 'Q', 'R', 'S', 'T'}, {'V', 'W', 'X', 'Y', 'Z'}};

    private static String findLocationByCharacter(char character) {
        StringBuilder location = new StringBuilder();
        block0: for (int i = 0; i < key.length; ++i) {
            for (int j = 0; j < key[i].length; ++j) {
                if (character != key[i][j]) continue;
                location.append(i).append(j);
                continue block0;
            }
        }
        return location.toString();
    }

    public static String encrypt(String plaintext) {
        char[] chars = plaintext.toUpperCase().toCharArray();
        StringBuilder ciphertext = new StringBuilder();
        for (char aChar : chars) {
            String location = Polybius.findLocationByCharacter(aChar);
            ciphertext.append(location);
        }
        return ciphertext.toString();
    }

    public static String decrypt(String ciphertext) {
        char[] chars = ciphertext.toCharArray();
        StringBuilder plaintext = new StringBuilder();
        for (int i = 0; i < chars.length; i += 2) {
            int pozitionX = Character.getNumericValue(chars[i]);
            int pozitionY = Character.getNumericValue(chars[i + 1]);
            plaintext.append(key[pozitionX][pozitionY]);
        }
        return plaintext.toString();
    }
}

