/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public class FileUtils {
    private static int getFilesCount(File source) {
        int count = 0;
        if (source.isDirectory()) {
            String[] files;
            for (String file : files = source.list()) {
                count += FileUtils.getFilesCount(new File(source, file));
            }
        } else {
            ++count;
        }
        return count;
    }

    private static void copyFolder(File source, File destination) {
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String file : files = source.list()) {
                File srcFile = new File(source, file);
                File destFile = new File(destination, file);
                FileUtils.copyFolder(srcFile, destFile);
            }
        } else {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int length;
                in = new FileInputStream(source);
                out = new FileOutputStream(destination);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void copyFromJar(String source, final Path target) {
        URI resource = null;
        FileSystem fileSystem = null;
        try {
            resource = this.getClass().getResource("").toURI();
            fileSystem = FileSystems.newFileSystem(resource, Collections.emptyMap());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        final Path jarPath = fileSystem.getPath(source, new String[0]);
        try {
            Files.walkFileTree(jarPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private Path currentTarget;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.currentTarget = target.resolve(jarPath.relativize(dir).toString());
                    Files.createDirectories(this.currentTarget, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(jarPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

