/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.yamlconfiguration.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigurationSection;
import wf.utils.java.file.yamlconfiguration.file.FileConfiguration;
import wf.utils.java.file.yamlconfiguration.file.YamlConfiguration;
import wf.utils.java.file.yamlconfiguration.utils.ConfigSerializable;
import wf.utils.java.file.yamlconfiguration.utils.StringSerializable;
import wf.utils.java.file.yamlconfiguration.utils.types.IntegerInRange;
import wf.utils.java.file.yamlconfiguration.utils.types.IntegerRandom;
import wf.utils.java.thread.loop.ThreadMultipleLoopTask;

public class Config {
    public File file;
    public FileConfiguration config;
    private ThreadMultipleLoopTask autoSaveLoopTask;
    private static HashMap<Integer, ThreadMultipleLoopTask> autoSaveLoopTaskMap;

    public Config(String path, String resourcePath) {
        try {
            this.file = new File(path);
            if (!this.file.exists()) {
                InputStream link = Config.class.getResourceAsStream(resourcePath);
                if (link == null) {
                    this.file.getAbsoluteFile().getParentFile().mkdirs();
                    this.file.getAbsoluteFile().createNewFile();
                } else {
                    Files.copy(link, this.file.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            this.config = YamlConfiguration.loadConfiguration(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Config(String path, String resourcePath, Collection<ConfigDefaultValue> defaultValues) {
        this(path, resourcePath);
        if (defaultValues != null && !defaultValues.isEmpty()) {
            this.setDefaultValues(defaultValues);
            this.save();
        }
    }

    public Config(String path) {
        try {
            this.file = new File(path);
            if (!this.file.exists()) {
                InputStream link = Config.class.getResourceAsStream(path);
                if (link == null) {
                    this.file.getAbsoluteFile().getParentFile().mkdirs();
                    this.file.getAbsoluteFile().createNewFile();
                } else {
                    Files.copy(link, this.file.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            this.config = YamlConfiguration.loadConfiguration(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Config(String path, String resourcePath, Collection<ConfigDefaultValue> defaultValues, int autoSaveSeconds, boolean autoSaveUnique) {
        try {
            this.file = new File(path);
            if (!this.file.exists()) {
                InputStream link = Config.class.getResourceAsStream(resourcePath);
                if (link == null) {
                    this.file.getAbsoluteFile().getParentFile().mkdirs();
                    this.file.getAbsoluteFile().createNewFile();
                } else {
                    Files.copy(link, this.file.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            this.config = YamlConfiguration.loadConfiguration(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (defaultValues != null && !defaultValues.isEmpty()) {
            this.setDefaultValues(defaultValues);
            this.save();
        }
        this.autoSaveInit(autoSaveSeconds, autoSaveUnique);
    }

    public Config(String path, Collection<ConfigDefaultValue> defaultValues) {
        try {
            this.file = new File(path);
            if (!this.file.exists()) {
                InputStream link = Config.class.getResourceAsStream(path);
                if (link == null) {
                    this.file.getParentFile().mkdirs();
                    this.file.createNewFile();
                } else {
                    Files.copy(link, this.file.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            this.config = YamlConfiguration.loadConfiguration(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (defaultValues != null && !defaultValues.isEmpty()) {
            this.setDefaultValues(defaultValues);
            this.save();
        }
    }

    private void autoSaveInit(int seconds, boolean unique) {
        if (!unique) {
            ThreadMultipleLoopTask task;
            if (autoSaveLoopTaskMap == null) {
                autoSaveLoopTaskMap = new HashMap();
            }
            if ((task = autoSaveLoopTaskMap.get(seconds)) == null) {
                task = new ThreadMultipleLoopTask((long)seconds * 1000L, (long)seconds * 1000L);
                autoSaveLoopTaskMap.put(seconds, task);
            }
            this.autoSaveLoopTask = task;
            this.autoSaveLoopTask.addRunnable(this.file.getAbsolutePath(), this::save);
            this.autoSaveLoopTask.start();
        } else {
            this.autoSaveLoopTask = new ThreadMultipleLoopTask((long)seconds * 1000L, (long)seconds * 1000L);
            this.autoSaveLoopTask.addRunnable(this.file.getAbsolutePath(), this::save);
            this.autoSaveLoopTask.start();
        }
    }

    public void stopAutoSave() {
        if (this.autoSaveLoopTask != null) {
            this.autoSaveLoopTask.stop();
        }
    }

    public void startAutoSave() {
        if (this.autoSaveLoopTask != null) {
            this.autoSaveLoopTask.start();
        }
    }

    public void setDefaultValues(boolean replace, Collection<ConfigDefaultValue> defaultValues) {
        for (ConfigDefaultValue value : defaultValues) {
            if (replace && this.config.contains(value.getPath())) continue;
            this.config.set(value.getPath(), value.getValue());
        }
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public void setDefaultValues(Collection<ConfigDefaultValue> defaultValues) {
        this.setDefaultValues(false, defaultValues);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<Long> getLongList(String path) {
        return this.config.getLongList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.config.getDoubleList(path);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.config.getBooleanList(path);
    }

    public List<Byte> getByteList(String path) {
        return this.config.getByteList(path);
    }

    public List<Float> getFloatList(String path) {
        return this.config.getFloatList(path);
    }

    public Object get(String path) {
        return this.config.get(path);
    }

    public <T> T getObject(String path, Class<T> type) {
        return this.config.getObject(path, type);
    }

    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    public long getLong(String path, long def) {
        return this.config.getLong(path, def);
    }

    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    public Object get(String path, Object def) {
        return this.config.get(path, def);
    }

    public <T> T getObject(String path, Class<T> type, T def) {
        return this.config.getObject(path, type, def);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public void set(String path, StringSerializable value) {
        this.set(path, value.getSerializableString());
    }

    public <T extends StringSerializable> T get(String path, T value) {
        return value.getSerializableObject(this.getString(path));
    }

    public <T extends ConfigSerializable> T get(String path, T value) {
        return (T)((ConfigSerializable)value.getSerializableObject(path, this));
    }

    public void set(String path, ConfigSerializable value) {
        value.setSerializableObject(path, this);
    }

    public void forEach(String path, Consumer<String> consumer) {
        this.forEach(path, false, consumer);
    }

    public void forEach(String path, boolean deap, Consumer<String> consumer) {
        for (String s : this.getConfigurationSection(path).getKeys(deap)) {
            consumer.accept(s);
        }
    }

    public void set(String path, IntegerRandom value) {
        this.set(path, value.getSerializableString());
    }

    public IntegerRandom getIntegerRandom(String path) {
        return new IntegerRandom().getSerializableObject(this.config.getString(path));
    }

    public void set(String path, IntegerInRange value) {
        this.set(path, value.getSerializableString());
    }

    public IntegerInRange getIntegerInRange(String path) {
        return new IntegerInRange().getSerializableObject(this.config.getString(path));
    }
}

