/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math.smooth.controller;

import java.util.ArrayList;
import java.util.List;
import wf.utils.java.math.smooth.SmoothTransform;
import wf.utils.java.math.smooth.controller.Item;

public class SmoothTransformController {
    private List<Item> items;
    private Thread thread;
    private int interval;

    public SmoothTransformController(int interval) {
        this(interval, new ArrayList<Item>());
    }

    public SmoothTransformController(int interval, List<Item> listTyped) {
        this.items = listTyped;
        this.interval = interval;
        this.thread = new Thread(() -> {
            while (true) {
                this.items.forEach(Item::run);
                this.items.removeIf(SmoothTransform::isEnd);
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String toString() {
        return "SmoothTransformController{items=" + this.items + ", thread=" + this.thread + ", interval=" + this.interval + "}";
    }
}

