/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class WordCollector {
    private static final String collectorUrl = "https://makeword.ru/combo/";

    public static HashMap<Integer, List<String>> collectWordsMap(String letters) {
        try {
            return WordCollector.toMap(Jsoup.connect((String)(collectorUrl + letters)).get().select("body > div.content_wrapper > div.content_left > ul > li > a").stream().map(Element::wholeText).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayList<String> collectWords(String letters) {
        HashMap<Integer, List<String>> wordsMap = WordCollector.collectWordsMap(letters);
        return (ArrayList)wordsMap.get(letters.length());
    }

    public static String collectWord(String letters) {
        ArrayList<String> words = WordCollector.collectWords(letters);
        if (words == null || words.size() == 0) {
            return null;
        }
        return words.get(0);
    }

    private static HashMap<Integer, List<String>> toMap(Collection<String> words) {
        HashMap<Integer, List<String>> sorted = new HashMap<Integer, List<String>>();
        words.forEach(w -> {
            if (sorted.containsKey(w.length())) {
                ((List)sorted.get(w.length())).add(w);
            } else {
                ArrayList<String> newList = new ArrayList<String>();
                newList.add((String)w);
                sorted.put(w.length(), newList);
            }
        });
        return sorted;
    }
}

