/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.object;

import java.lang.reflect.Field;
import java.util.Arrays;
import wf.utils.java.values.DefaultDataType;

public class ObjectToString {
    public static String convert(Object object) {
        StringBuilder builder = new StringBuilder(object.getClass().getSimpleName() + "{\n");
        for (Field field : object.getClass().getDeclaredFields()) {
            builder.append("    " + ObjectToString.filedToString(object, field));
        }
        builder.append("}");
        return builder.toString();
    }

    public static String filedToString(Object object, Field field) {
        Object result;
        field.setAccessible(true);
        if (!field.isAccessible()) {
            return "";
        }
        field.setAccessible(true);
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            return field.getName() + "=null";
        }
        if (DefaultDataType.itsDefaultType(result)) {
            if (DefaultDataType.itsDefaultArray(result)) {
                return field.getName() + "=" + Arrays.toString((Object[])result) + ", \n";
            }
            return field.getName() + "=" + result.toString() + ", \n";
        }
        return ObjectToString.convert(result);
    }
}

