/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.thread.mutex;

import wf.utils.java.thread.mutex.Mutex;

public class MutexWhileThread
extends Thread {
    private final Mutex mutex;
    private Runnable runnable;

    public MutexWhileThread(Runnable runnable) {
        this(runnable, false);
    }

    public MutexWhileThread(Runnable runnable, boolean block) {
        this.runnable = runnable;
        this.mutex = new Mutex(block);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            this.mutex.step();
            this.runnable.run();
        }
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public Mutex getMutex() {
        return this.mutex;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public String toString() {
        return "MutexWhileThread{mutex=" + this.mutex + ", runnable=" + this.runnable + "}";
    }
}

