/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.time.cooldown;

import java.util.HashMap;
import java.util.Map;
import wf.utils.java.time.cooldown.TimeController;

public class CoolDown<T> {
    private Map<T, TimeController> items;
    private boolean autoRemove = true;

    public CoolDown() {
        this.items = new HashMap<T, TimeController>();
    }

    public CoolDown(int size) {
        this.items = new HashMap<T, TimeController>(size);
    }

    public CoolDown(boolean autoRemove) {
        this.items = new HashMap<T, TimeController>();
        this.autoRemove = autoRemove;
    }

    public CoolDown(boolean autoRemove, int size) {
        this.items = new HashMap<T, TimeController>(size);
        this.autoRemove = autoRemove;
    }

    public boolean timeOver(T item) {
        if (!this.items.containsKey(item)) {
            return true;
        }
        if (this.items.get(item).timeLeft() > 0L) {
            return false;
        }
        if (this.autoRemove) {
            this.items.remove(item);
        }
        return true;
    }

    public void addItem(T item, long time) {
        this.items.put(item, new TimeController(time));
    }

    public long timeLeft(T item) {
        TimeController controller = this.items.get(item);
        return controller == null ? 0L : Math.max(controller.timeLeft(), 0L);
    }

    public int secondsLeft(T item) {
        return (int)(this.timeLeft(item) / 1000L);
    }

    public double secondsLeftCorrected(T item, double numbers) {
        numbers = Math.pow(10.0, Math.min(numbers, 3.0));
        return (double)Math.round((double)this.timeLeft(item) / 1000.0 * numbers) / numbers;
    }

    public double secondsLeftCorrected(T item) {
        return (double)Math.round((double)this.timeLeft(item) / 100.0) / 10.0;
    }

    public void clearCache() {
        this.items.entrySet().removeIf(i -> ((TimeController)i.getValue()).timeLeft() < 0L);
    }

    public Map<T, TimeController> getItems() {
        return this.items;
    }

    public void setItems(Map<T, TimeController> items) {
        this.items = items;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    public String toString() {
        return "CoolDown{items=" + this.items + ", autoRemove=" + this.autoRemove + "}";
    }
}

