/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers;

public class Caesar {
    public String encode(String message, int shift) {
        StringBuilder encoded = new StringBuilder();
        shift %= 26;
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int current = message.charAt(i);
            if (Caesar.isCapitalLatinLetter((char)current)) {
                encoded.append((char)((current = (char)(current + shift)) > 90 ? current - 26 : current));
                continue;
            }
            if (Caesar.isSmallLatinLetter((char)current)) {
                encoded.append((char)((current = (char)(current + shift)) > 122 ? current - 26 : current));
                continue;
            }
            encoded.append((char)current);
        }
        return encoded.toString();
    }

    public String decode(String encryptedMessage, int shift) {
        StringBuilder decoded = new StringBuilder();
        shift %= 26;
        int length = encryptedMessage.length();
        for (int i = 0; i < length; ++i) {
            int current = encryptedMessage.charAt(i);
            if (Caesar.isCapitalLatinLetter((char)current)) {
                decoded.append((char)((current = (char)(current - shift)) < 65 ? current + 26 : current));
                continue;
            }
            if (Caesar.isSmallLatinLetter((char)current)) {
                decoded.append((char)((current = (char)(current - shift)) < 97 ? current + 26 : current));
                continue;
            }
            decoded.append((char)current);
        }
        return decoded.toString();
    }

    private static boolean isCapitalLatinLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isSmallLatinLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    public String[] bruteforce(String encryptedMessage) {
        String[] listOfAllTheAnswers = new String[27];
        for (int i = 0; i <= 26; ++i) {
            listOfAllTheAnswers[i] = this.decode(encryptedMessage, i);
        }
        return listOfAllTheAnswers;
    }
}

