/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers.a5;

import java.util.BitSet;
import wf.utils.java.algoritms.ciphers.a5.BaseLFSR;

public class LFSR
implements BaseLFSR {
    private final BitSet register;
    private final int length;
    private final int clockBitIndex;
    private final int[] tappingBitsIndices;

    public LFSR(int length, int clockBitIndex, int[] tappingBitsIndices) {
        this.length = length;
        this.clockBitIndex = clockBitIndex;
        this.tappingBitsIndices = tappingBitsIndices;
        this.register = new BitSet(length);
    }

    @Override
    public void initialize(BitSet sessionKey, BitSet frameCounter) {
        this.register.clear();
        this.clock(sessionKey, 64);
        this.clock(frameCounter, 22);
    }

    private void clock(BitSet key, int keyLength) {
        for (int i = keyLength - 1; i >= 0; --i) {
            boolean newBit = key.get(i) ^ this.xorTappingBits();
            this.pushBit(newBit);
        }
    }

    @Override
    public boolean clock() {
        return this.pushBit(this.xorTappingBits());
    }

    public boolean getClockBit() {
        return this.register.get(this.clockBitIndex);
    }

    public boolean get(int bitIndex) {
        return this.register.get(bitIndex);
    }

    public boolean getLastBit() {
        return this.register.get(this.length - 1);
    }

    private boolean xorTappingBits() {
        boolean result = false;
        for (int i : this.tappingBitsIndices) {
            result ^= this.register.get(i);
        }
        return result;
    }

    private boolean pushBit(boolean bit) {
        boolean discardedBit = this.rightShift();
        this.register.set(0, bit);
        return discardedBit;
    }

    private boolean rightShift() {
        boolean discardedBit = this.get(this.length - 1);
        for (int i = this.length - 1; i > 0; --i) {
            this.register.set(i, this.get(i - 1));
        }
        this.register.set(0, false);
        return discardedBit;
    }

    public String toString() {
        return this.register.toString();
    }
}

