/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.data.string;

import java.util.HashMap;
import java.util.Iterator;

public class StringUtils {
    public static boolean isAllCharactersSame(String s) {
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            if (s.charAt(i) == s.charAt(0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnagrams(String s1, String s2) {
        char c;
        int i;
        int l1 = s1.length();
        int l2 = s2.length();
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        HashMap<Character, Integer> charAppearances = new HashMap<Character, Integer>();
        for (i = 0; i < l1; ++i) {
            c = s1.charAt(i);
            int numOfAppearances = charAppearances.getOrDefault(Character.valueOf(c), 0);
            charAppearances.put(Character.valueOf(c), numOfAppearances + 1);
        }
        for (i = 0; i < l2; ++i) {
            c = s2.charAt(i);
            if (!charAppearances.containsKey(Character.valueOf(c))) {
                return false;
            }
            charAppearances.put(Character.valueOf(c), (Integer)charAppearances.get(Character.valueOf(c)) - 1);
        }
        Iterator iterator = charAppearances.values().iterator();
        while (iterator.hasNext()) {
            int cnt = (Integer)iterator.next();
            if (cnt == 0) continue;
            return false;
        }
        return true;
    }

    public static int calculateHammingDistance(String s1, String s2) throws Exception {
        if (s1.length() != s2.length()) {
            throw new Exception("String lengths must be equal");
        }
        int stringLength = s1.length();
        int counter = 0;
        for (int i = 0; i < stringLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++counter;
        }
        return counter;
    }

    public static double stringSame(String str1, String str2) {
        return 1.0 - (double)StringUtils.stringDistance(str1, str2) / (double)Math.max(str1.length(), str2.length());
    }

    public static int stringDistance(String str1, String str2) {
        str1 = str1.toLowerCase();
        str2 = str2.toLowerCase();
        int m = str1.length();
        int n = str2.length();
        int[][] T = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            T[i][0] = i;
        }
        for (int j = 1; j <= n; ++j) {
            T[0][j] = j;
        }
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                int cost = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                T[i][j] = Integer.min(Integer.min(T[i - 1][j] + 1, T[i][j - 1] + 1), T[i - 1][j - 1] + cost);
            }
        }
        return T[m][n];
    }

    public static double getSimilarity(String str1, String str2) {
        if (str1 == null || str2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        double maxLength = Double.max(str1.length(), str2.length());
        if (maxLength > 0.0) {
            return (maxLength - StringUtils.stringSame(str1, str2)) / maxLength;
        }
        return 1.0;
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static boolean isValidParentheses(String s) {
        char[] stack = new char[s.length()];
        int head = 0;
        block6: for (char c : s.toCharArray()) {
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    stack[head++] = c;
                    continue block6;
                }
                case '}': {
                    if (head != 0 && stack[--head] == '{') continue block6;
                    return false;
                }
                case ')': {
                    if (head != 0 && stack[--head] == '(') continue block6;
                    return false;
                }
                case ']': {
                    if (head != 0 && stack[--head] == '[') continue block6;
                    return false;
                }
            }
        }
        return head == 0;
    }
}

