/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.yamlconfiguration.utils.types;

import java.util.Random;
import wf.utils.java.file.yamlconfiguration.utils.StringSerializable;

public class IntegerRandom
implements StringSerializable<IntegerRandom> {
    private int min;
    private int max;
    private Random random;

    public IntegerRandom() {
    }

    public IntegerRandom(int min, int max) {
        if (min > max) {
            int n = min + max;
            max = min;
            min = n - max;
        }
        this.min = min;
        this.max = max;
        this.random = new Random();
    }

    public IntegerRandom(String s) {
        this(s.split(":")[0].isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(s.split(":")[0]), s.split(":")[1].isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(s.split(":")[1]));
    }

    public int get() {
        return (int)(this.random.nextDouble() * (double)(this.max - this.min + 1) + (double)this.min);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public IntegerRandom getSerializableObject(String s) {
        return new IntegerRandom(s);
    }

    @Override
    public String getSerializableString() {
        return (this.min == Integer.MIN_VALUE ? "" : Integer.valueOf(this.min)) + ".." + (this.max == Integer.MAX_VALUE ? "" : Integer.valueOf(this.max));
    }

    public String toString() {
        return "IntegerRandom{min=" + this.min + ", max=" + this.max + ", random=" + this.random + '}';
    }
}

