/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math;

import wf.utils.java.math.MathUtils;

public class MathEval {
    public static double eval(String expression) {
        return MathEval.eval(expression, true);
    }

    public static double eval(String expression, final boolean floatFix) {
        final String str = expression.toLowerCase();
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    if (!this.eat(41)) {
                        throw new RuntimeException("Missing ')'");
                    }
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else {
                    if (this.ch < 97 || this.ch > 122) throw new RuntimeException("Unexpected: " + (char)this.ch);
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    if (this.eat(40)) {
                        x = this.parseExpression();
                        if (!this.eat(41)) {
                            throw new RuntimeException("Missing ')' after argument to " + func);
                        }
                    } else {
                        x = this.parseFactor();
                    }
                    if (func.equals("sqrt")) {
                        x = Math.sqrt(x);
                    } else if (func.equals("sin")) {
                        x = Math.sin(Math.toRadians(x));
                    } else if (func.equals("cos")) {
                        x = Math.cos(Math.toRadians(x));
                    } else if (func.equals("tan")) {
                        x = Math.tan(Math.toRadians(x));
                    } else if (func.equals("round")) {
                        x = Math.round(x);
                    } else if (func.equals("ceil")) {
                        x = Math.ceil(x);
                    } else if (func.equals("floor")) {
                        x = Math.floor(x);
                    } else if (func.equals("asin") || func.equals("arcsin")) {
                        x = Math.toDegrees(Math.asin(x));
                    } else {
                        if (!func.equals("acos") && !func.equals("arccos")) throw new RuntimeException("Unknown function: " + func);
                        x = Math.toDegrees(Math.acos(x));
                    }
                }
                if (!this.eat(94)) return floatFix ? MathUtils.floatFix(x) : x;
                x = Math.pow(x, this.parseFactor());
                return floatFix ? MathUtils.floatFix(x) : x;
            }
        }.parse();
    }
}

