/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math;

public class MathUtils {
    public static double[] getConfusion(double x, double y, double z) {
        double max = Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
        return new double[]{x / max, y / max, z / max, max};
    }

    public static double[] getConfusion(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.getConfusion(x1 - x2, y1 - y2, z1 - z2);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }

    public static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    public static long factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number is negative");
        }
        return n == 0 || n == 1 ? 1L : (long)n * MathUtils.factorial(n - 1);
    }

    public static long combinations(int n, int k) {
        return MathUtils.factorial(n) / (MathUtils.factorial(k) * MathUtils.factorial(n - k));
    }

    public static long combinationsOptimized(int n, int k) {
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException("n or k can't be negative");
        }
        if (n < k) {
            throw new IllegalArgumentException("n can't be smaller than k");
        }
        long solution = 1L;
        for (int i = 0; i < k; ++i) {
            long next;
            solution = next = (long)(n - i) * solution / (long)(i + 1);
        }
        return solution;
    }

    public static int findMax(int ... array) {
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static double findMax(double ... array) {
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static int findMin(int ... array) {
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static double findMin(double ... array) {
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double roundToNearestNumber(double number, double toRoundNumber) {
        return (double)Math.round(number / toRoundNumber) * toRoundNumber;
    }

    public static double floatFix(double d) {
        return (double)Math.round((d + 4.0E-15) * 1.0E9) / 1.0E9;
    }

    public static double roundTo10(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    public static double roundTo100(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static double roundTo1000(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    public static double roundTo10000(double value) {
        return (double)Math.round(value * 10000.0) / 10000.0;
    }
}

