/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.time.execution;

import wf.utils.java.data.number.NumberUtils;

public class ExecutionTimeNano {
    private long startTime = System.nanoTime();

    public long getNano() {
        return System.nanoTime() - this.startTime;
    }

    public double getMillis() {
        return (double)this.getNano() / 1000000.0;
    }

    public double getSeconds() {
        return (double)this.getNano() / 1.0E9;
    }

    public String getSecondsFormatted() {
        return NumberUtils.formatNumber(this.getSeconds(), 1);
    }

    public String getSecondsFormatted(int count) {
        return NumberUtils.formatNumber(this.getSeconds(), count);
    }

    public void update() {
        this.startTime = System.nanoTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return "ExecutionTimeNano{startTime=" + this.startTime + '}';
    }
}

