/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.sorts;

import wf.utils.java.algoritms.sorts.SortAlgorithm;
import wf.utils.java.algoritms.sorts.SortUtils;

public class InsertionSort
implements SortAlgorithm {
    @Override
    public <T extends Comparable<T>> T[] sort(T[] array) {
        return this.sort((Comparable[])array, 0, array.length);
    }

    public <T extends Comparable<T>> T[] sort(T[] array, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            for (int j = i; j > lo && SortUtils.less(array[j], array[j - 1]); --j) {
                SortUtils.swap(array, j, j - 1);
            }
        }
        return array;
    }

    public <T extends Comparable<T>> T[] sentinelSort(T[] array) {
        int i;
        int minElemIndex = 0;
        int n = array.length;
        if (n < 1) {
            return array;
        }
        for (i = 1; i < n; ++i) {
            if (!SortUtils.less(array[i], array[minElemIndex])) continue;
            minElemIndex = i;
        }
        SortUtils.swap(array, 0, minElemIndex);
        for (i = 2; i < n; ++i) {
            int j = i;
            T currentValue = array[i];
            while (SortUtils.less(currentValue, array[j - 1])) {
                array[j] = array[j - 1];
                --j;
            }
            array[j] = currentValue;
        }
        return array;
    }
}

