/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers.a5;

import java.util.BitSet;
import wf.utils.java.algoritms.ciphers.a5.CompositeLFSR;
import wf.utils.java.algoritms.ciphers.a5.LFSR;
import wf.utils.java.algoritms.ciphers.a5.Utils;

public class A5KeyStreamGenerator
extends CompositeLFSR {
    private BitSet initialFrameCounter;
    private BitSet frameCounter;
    private BitSet sessionKey;
    private static final int INITIAL_CLOCKING_CYCLES = 100;
    private static final int KEY_STREAM_LENGTH = 228;

    @Override
    public void initialize(BitSet sessionKey, BitSet frameCounter) {
        this.sessionKey = sessionKey;
        this.frameCounter = (BitSet)frameCounter.clone();
        this.initialFrameCounter = (BitSet)frameCounter.clone();
        this.registers.clear();
        LFSR lfsr1 = new LFSR(19, 8, new int[]{13, 16, 17, 18});
        LFSR lfsr2 = new LFSR(22, 10, new int[]{20, 21});
        LFSR lfsr3 = new LFSR(23, 10, new int[]{7, 20, 21, 22});
        this.registers.add(lfsr1);
        this.registers.add(lfsr2);
        this.registers.add(lfsr3);
        this.registers.forEach(lfsr -> lfsr.initialize(sessionKey, frameCounter));
    }

    public void reInitialize() {
        this.initialize(this.sessionKey, this.initialFrameCounter);
    }

    public BitSet getNextKeyStream() {
        for (int cycle = 1; cycle <= 100; ++cycle) {
            this.clock();
        }
        BitSet result = new BitSet(228);
        for (int cycle = 1; cycle <= 228; ++cycle) {
            boolean outputBit = this.clock();
            result.set(cycle - 1, outputBit);
        }
        this.reInitializeRegisters();
        return result;
    }

    private void reInitializeRegisters() {
        this.incrementFrameCounter();
        this.registers.forEach(lfsr -> lfsr.initialize(this.sessionKey, this.frameCounter));
    }

    private void incrementFrameCounter() {
        Utils.increment(this.frameCounter, 22);
    }
}

