/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class FileNewLinesListener {
    private Thread thread;

    public FileNewLinesListener(final String path, final Consumer<String> run) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]), "windows-1251"));
                    reader.skip(Long.MAX_VALUE);
                    String line = reader.readLine();
                    while (true) {
                        if (line == null) {
                            Thread.sleep(25L);
                        } else {
                            run.accept(line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    public void stop() {
        this.thread.stop();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public String toString() {
        return "FileNewLinesReader{thread=" + this.thread + '}';
    }
}

