/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math;

public enum Encoder {
    DIGITS("0123456789"),
    LOWER_LETTERS("abcdefghijklmnopqrstuvwxyz"),
    UPPER_LETTERS("ABCDEFGHIJKLMNOPQRSTUVWXYZ"),
    SPECIAL_SYMBOLS(".<>!()~-_\""),
    RADIX_10(DIGITS.getSymbols()),
    RADIX_36(RADIX_10.getSymbols() + LOWER_LETTERS.getSymbols()),
    RADIX_62(RADIX_36.getSymbols() + UPPER_LETTERS.getSymbols()),
    RADIX_72(RADIX_62.getSymbols() + SPECIAL_SYMBOLS.getSymbols());

    private final String symbols;

    private Encoder(String symbols) {
        this.symbols = symbols;
    }

    public String encode(long l) {
        return Encoder.encode(l, this);
    }

    public long decode(String s) {
        return Encoder.decode(s, this);
    }

    public boolean isValid(String s) {
        return Encoder.isValid(s, this);
    }

    public static String encode(long l, Encoder encoder) {
        String symbols = encoder.getSymbols();
        StringBuilder sb = new StringBuilder();
        while (l > 0L) {
            sb.append(symbols.charAt((int)(l % (long)symbols.length())));
            l /= (long)symbols.length();
        }
        return sb.reverse().toString();
    }

    public static long decode(String s, Encoder encoder) {
        String symbols = encoder.getSymbols();
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int digit = symbols.indexOf(c);
            result = result * (long)symbols.length() + (long)digit;
        }
        return result;
    }

    public static boolean isValid(String s, Encoder encoder) {
        String allowedSymbols = encoder.getSymbols();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (allowedSymbols.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public String getSymbols() {
        return this.symbols;
    }
}

