/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math.smooth.controller;

import java.util.HashMap;
import java.util.Map;
import wf.utils.java.math.smooth.controller.Item;

public class SmoothTransformEntityController<T> {
    private Map<T, Item> items;
    private Thread thread;
    private int interval;

    public SmoothTransformEntityController(int interval) {
        this(interval, new HashMap());
    }

    public SmoothTransformEntityController(int interval, Map<T, Item> mapTyped) {
        this.items = mapTyped;
        this.interval = interval;
        this.thread = new Thread(() -> {
            while (true) {
                this.items.forEach((k, v) -> v.run());
                this.items.entrySet().removeIf(e -> ((Item)e.getValue()).isEnd());
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void setOrUpdateItem(T t, Item item) {
        Item currentItem = this.items.get(t);
        if (currentItem == null) {
            this.items.put(t, item);
        } else {
            currentItem.setTo(item.getTo());
            currentItem.setRunnable(item.getRunnable());
            currentItem.setDuration(item.getDuration());
        }
    }

    public void setItem(T t, Item item) {
        this.items.put(t, item);
    }

    public Map<T, Item> getItems() {
        return this.items;
    }

    public void setItems(Map<T, Item> items) {
        this.items = items;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String toString() {
        return "SmoothTransformController{items=" + this.items + ", thread=" + this.thread + ", interval=" + this.interval + '}';
    }
}

