/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.thread.queue;

import java.util.Comparator;
import java.util.PriorityQueue;
import wf.utils.java.thread.mutex.MutexWhileThread;
import wf.utils.java.thread.queue.QueueKey;

public class Queue {
    private PriorityQueue<QueueKey> queue = new PriorityQueue<QueueKey>(new Comparator<QueueKey>(){

        @Override
        public int compare(QueueKey o1, QueueKey o2) {
            int compare = Integer.compare(o2.getPriority(), o1.getPriority());
            if (compare != 0) {
                return compare;
            }
            return Long.compare(o1.getCreateTime(), o2.getCreateTime());
        }
    });
    private MutexWhileThread thread = new MutexWhileThread(this::executeQueue);

    public Queue() {
    }

    public Queue(boolean daemon) {
        this.thread.setDaemon(daemon);
    }

    public Queue start() {
        this.thread.start();
        return this;
    }

    private void executeQueue() {
        if (this.queue.size() == 0) {
            this.thread.lock();
            return;
        }
        this.queue.poll().getRunnable().run();
    }

    public void addQueue(QueueKey key) {
        this.queue.add(key);
        this.update();
    }

    public void addQueue(Runnable runnable) {
        this.queue.add(new QueueKey(runnable));
        this.update();
    }

    public void addQueue(Runnable runnable, String name) {
        this.queue.add(new QueueKey(runnable, name));
        this.update();
    }

    public void addQueue(Runnable runnable, int priority) {
        this.queue.add(new QueueKey(runnable, priority));
        this.update();
    }

    public void addQueue(Runnable runnable, int priority, String name) {
        this.queue.add(new QueueKey(runnable, priority, name));
        this.update();
    }

    public boolean remove(QueueKey key) {
        return this.queue.remove(key);
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean remove(String name) {
        return this.queue.removeIf(key -> key.getName().equals(name));
    }

    public void update() {
        if (this.thread == null || this.thread.getState() == Thread.State.NEW) {
            return;
        }
        this.thread.unlock();
    }

    public MutexWhileThread getThread() {
        return this.thread;
    }
}

