/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.convert;

public class RgbHsvConvert {
    public static int[] hsvToRgb(double hue, double saturation, double value) {
        if (hue < 0.0 || hue > 360.0) {
            throw new IllegalArgumentException("hue should be between 0 and 360");
        }
        if (saturation < 0.0 || saturation > 1.0) {
            throw new IllegalArgumentException("saturation should be between 0 and 1");
        }
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("value should be between 0 and 1");
        }
        double chroma = value * saturation;
        double hueSection = hue / 60.0;
        double secondLargestComponent = chroma * (1.0 - Math.abs(hueSection % 2.0 - 1.0));
        double matchValue = value - chroma;
        return RgbHsvConvert.getRgbBySection(hueSection, chroma, matchValue, secondLargestComponent);
    }

    public static double[] rgbToHsv(int red, int green, int blue) {
        double saturation;
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("red should be between 0 and 255");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("green should be between 0 and 255");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("blue should be between 0 and 255");
        }
        double dRed = (double)red / 255.0;
        double dGreen = (double)green / 255.0;
        double dBlue = (double)blue / 255.0;
        double value = Math.max(Math.max(dRed, dGreen), dBlue);
        double chroma = value - Math.min(Math.min(dRed, dGreen), dBlue);
        double d = saturation = value == 0.0 ? 0.0 : chroma / value;
        double hue = chroma == 0.0 ? 0.0 : (value == dRed ? 60.0 * (0.0 + (dGreen - dBlue) / chroma) : (value == dGreen ? 60.0 * (2.0 + (dBlue - dRed) / chroma) : 60.0 * (4.0 + (dRed - dGreen) / chroma)));
        hue = (hue + 360.0) % 360.0;
        return new double[]{hue, saturation, value};
    }

    private static boolean approximatelyEqualHsv(double[] hsv1, double[] hsv2) {
        boolean bHue = Math.abs(hsv1[0] - hsv2[0]) < 0.2;
        boolean bSaturation = Math.abs(hsv1[1] - hsv2[1]) < 0.002;
        boolean bValue = Math.abs(hsv1[2] - hsv2[2]) < 0.002;
        return bHue && bSaturation && bValue;
    }

    private static int[] getRgbBySection(double hueSection, double chroma, double matchValue, double secondLargestComponent) {
        int blue;
        int green;
        int red;
        if (hueSection >= 0.0 && hueSection <= 1.0) {
            red = RgbHsvConvert.convertToInt(chroma + matchValue);
            green = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
            blue = RgbHsvConvert.convertToInt(matchValue);
        } else if (hueSection > 1.0 && hueSection <= 2.0) {
            red = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
            green = RgbHsvConvert.convertToInt(chroma + matchValue);
            blue = RgbHsvConvert.convertToInt(matchValue);
        } else if (hueSection > 2.0 && hueSection <= 3.0) {
            red = RgbHsvConvert.convertToInt(matchValue);
            green = RgbHsvConvert.convertToInt(chroma + matchValue);
            blue = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
        } else if (hueSection > 3.0 && hueSection <= 4.0) {
            red = RgbHsvConvert.convertToInt(matchValue);
            green = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
            blue = RgbHsvConvert.convertToInt(chroma + matchValue);
        } else if (hueSection > 4.0 && hueSection <= 5.0) {
            red = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
            green = RgbHsvConvert.convertToInt(matchValue);
            blue = RgbHsvConvert.convertToInt(chroma + matchValue);
        } else {
            red = RgbHsvConvert.convertToInt(chroma + matchValue);
            green = RgbHsvConvert.convertToInt(matchValue);
            blue = RgbHsvConvert.convertToInt(secondLargestComponent + matchValue);
        }
        return new int[]{red, green, blue};
    }

    private static int convertToInt(double input) {
        return (int)Math.round(255.0 * input);
    }
}

