/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers;

public class ColumnarTranspositionCipher {
    private static String keyword;
    private static Object[][] table;
    private static String abecedarium;
    public static final String ABECEDARIUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,.;:-@";
    private static final String ENCRYPTION_FIELD = "\u2248";
    private static final char ENCRYPTION_FIELD_CHAR = '\u2248';

    public static String encrpyter(String word, String keyword) {
        ColumnarTranspositionCipher.keyword = keyword;
        ColumnarTranspositionCipher.abecedariumBuilder(500);
        table = ColumnarTranspositionCipher.tableBuilder(word);
        Object[][] sortedTable = ColumnarTranspositionCipher.sortTable(table);
        StringBuilder wordEncrypted = new StringBuilder();
        for (int i = 0; i < sortedTable[i].length; ++i) {
            for (int j = 1; j < sortedTable.length; ++j) {
                wordEncrypted.append(sortedTable[j][i]);
            }
        }
        return wordEncrypted.toString();
    }

    public static String encrpyter(String word, String keyword, String abecedarium) {
        ColumnarTranspositionCipher.keyword = keyword;
        ColumnarTranspositionCipher.abecedarium = abecedarium != null ? abecedarium : ABECEDARIUM;
        table = ColumnarTranspositionCipher.tableBuilder(word);
        Object[][] sortedTable = ColumnarTranspositionCipher.sortTable(table);
        StringBuilder wordEncrypted = new StringBuilder();
        for (int i = 0; i < sortedTable[0].length; ++i) {
            for (int j = 1; j < sortedTable.length; ++j) {
                wordEncrypted.append(sortedTable[j][i]);
            }
        }
        return wordEncrypted.toString();
    }

    public static String decrypter() {
        StringBuilder wordDecrypted = new StringBuilder();
        for (int i = 1; i < table.length; ++i) {
            for (Object item : table[i]) {
                wordDecrypted.append(item);
            }
        }
        return wordDecrypted.toString().replaceAll(ENCRYPTION_FIELD, "");
    }

    private static Object[][] tableBuilder(String word) {
        Object[][] table = new Object[ColumnarTranspositionCipher.numberOfRows(word) + 1][keyword.length()];
        char[] wordInChards = word.toCharArray();
        table[0] = ColumnarTranspositionCipher.findElements();
        int charElement = 0;
        for (int i = 1; i < table.length; ++i) {
            for (int j = 0; j < table[i].length; ++j) {
                if (charElement < wordInChards.length) {
                    table[i][j] = Character.valueOf(wordInChards[charElement]);
                    ++charElement;
                    continue;
                }
                table[i][j] = Character.valueOf('\u2248');
            }
        }
        return table;
    }

    private static int numberOfRows(String word) {
        if (word.length() / keyword.length() > word.length() / keyword.length()) {
            return word.length() / keyword.length() + 1;
        }
        return word.length() / keyword.length();
    }

    private static Object[] findElements() {
        Object[] charValues = new Object[keyword.length()];
        for (int i = 0; i < charValues.length; ++i) {
            int charValueIndex = abecedarium.indexOf(keyword.charAt(i));
            charValues[i] = charValueIndex > -1 ? Integer.valueOf(charValueIndex) : null;
        }
        return charValues;
    }

    private static Object[][] sortTable(Object[][] table) {
        int i;
        Object[][] tableSorted = new Object[table.length][table[0].length];
        for (i = 0; i < tableSorted.length; ++i) {
            System.arraycopy(table[i], 0, tableSorted[i], 0, tableSorted[i].length);
        }
        for (i = 0; i < tableSorted[0].length; ++i) {
            for (int j = i + 1; j < tableSorted[0].length; ++j) {
                if ((Integer)tableSorted[0][i] <= (Integer)table[0][j]) continue;
                Object[] column = ColumnarTranspositionCipher.getColumn(tableSorted, tableSorted.length, i);
                ColumnarTranspositionCipher.switchColumns(tableSorted, j, i, column);
            }
        }
        return tableSorted;
    }

    private static Object[] getColumn(Object[][] table, int rows, int column) {
        Object[] columnArray = new Object[rows];
        for (int i = 0; i < rows; ++i) {
            columnArray[i] = table[i][column];
        }
        return columnArray;
    }

    private static void switchColumns(Object[][] table, int firstColumnIndex, int secondColumnIndex, Object[] columnToSwitch) {
        for (int i = 0; i < table.length; ++i) {
            table[i][secondColumnIndex] = table[i][firstColumnIndex];
            table[i][firstColumnIndex] = columnToSwitch[i];
        }
    }

    private static void abecedariumBuilder(int value) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < value; ++i) {
            t.append((char)i);
        }
        abecedarium = t.toString();
    }

    private static void showTable() {
        Object[][] objectArray = table;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] table1;
            for (Object item : table1 = objectArray[i]) {
                System.out.print(item + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        String keywordForExample = "asd215";
        String wordBeingEncrypted = "This is a test of the Columnar Transposition Cipher";
        System.out.println("### Example of Columnar Transposition Cipher ###\n");
        System.out.println("Word being encryped ->>> " + wordBeingEncrypted);
        System.out.println("Word encrypted ->>> " + ColumnarTranspositionCipher.encrpyter(wordBeingEncrypted, keywordForExample));
        System.out.println("Word decryped ->>> " + ColumnarTranspositionCipher.decrypter());
        System.out.println("\n### Encrypted Table ###");
        ColumnarTranspositionCipher.showTable();
    }
}

