/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers;

import java.math.BigInteger;
import java.security.SecureRandom;

public class RSA {
    private BigInteger modulus;
    private BigInteger privateKey;
    private BigInteger publicKey;

    public RSA(int bits) {
        this.generateKeys(bits);
    }

    public synchronized String encrypt(String message) {
        return new BigInteger(message.getBytes()).modPow(this.publicKey, this.modulus).toString();
    }

    public synchronized BigInteger encrypt(BigInteger message) {
        return message.modPow(this.publicKey, this.modulus);
    }

    public synchronized String decrypt(String encryptedMessage) {
        return new String(new BigInteger(encryptedMessage).modPow(this.privateKey, this.modulus).toByteArray());
    }

    public synchronized BigInteger decrypt(BigInteger encryptedMessage) {
        return encryptedMessage.modPow(this.privateKey, this.modulus);
    }

    public synchronized void generateKeys(int bits) {
        SecureRandom r = new SecureRandom();
        BigInteger p = new BigInteger(bits / 2, 100, r);
        BigInteger q = new BigInteger(bits / 2, 100, r);
        this.modulus = p.multiply(q);
        BigInteger m = p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE));
        this.publicKey = BigInteger.valueOf(3L);
        while (m.gcd(this.publicKey).intValue() > 1) {
            this.publicKey = this.publicKey.add(BigInteger.valueOf(2L));
        }
        this.privateKey = this.publicKey.modInverse(m);
    }
}

