/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers;

public class Vigenere {
    public String encrypt(String message, String key) {
        StringBuilder result = new StringBuilder();
        int j = 0;
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (Character.isLetter(c)) {
                if (Character.isUpperCase(c)) {
                    result.append((char)((c + key.toUpperCase().charAt(j) - 130) % 26 + 65));
                } else {
                    result.append((char)((c + key.toLowerCase().charAt(j) - 194) % 26 + 97));
                }
            } else {
                result.append(c);
            }
            ++j;
            j %= key.length();
        }
        return result.toString();
    }

    public String decrypt(String message, String key) {
        StringBuilder result = new StringBuilder();
        int j = 0;
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (Character.isLetter(c)) {
                if (Character.isUpperCase(c)) {
                    result.append((char)(90 - (25 - (c - key.toUpperCase().charAt(j))) % 26));
                } else {
                    result.append((char)(122 - (25 - (c - key.toLowerCase().charAt(j))) % 26));
                }
            } else {
                result.append(c);
            }
            ++j;
            j %= key.length();
        }
        return result.toString();
    }
}

