/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.ciphers.a5;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import wf.utils.java.algoritms.ciphers.a5.BaseLFSR;
import wf.utils.java.algoritms.ciphers.a5.LFSR;

public abstract class CompositeLFSR
implements BaseLFSR {
    protected final List<LFSR> registers = new ArrayList<LFSR>();

    @Override
    public boolean clock() {
        boolean majorityBit = this.getMajorityBit();
        boolean result = false;
        for (LFSR register : this.registers) {
            result ^= register.getLastBit();
            if (register.getClockBit() != majorityBit) continue;
            register.clock();
        }
        return result;
    }

    private boolean getMajorityBit() {
        TreeMap<Boolean, Integer> bitCount = new TreeMap<Boolean, Integer>();
        bitCount.put(false, 0);
        bitCount.put(true, 0);
        this.registers.forEach(lfsr -> bitCount.put(lfsr.getClockBit(), (Integer)bitCount.get(lfsr.getClockBit()) + 1));
        return (Integer)bitCount.get(false) <= (Integer)bitCount.get(true);
    }
}

