/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.convert;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class StringToPoints {
    public static String convert(String text, double widthScale, double heightScale, String fontName, int fontSize) {
        Font font = new Font(fontName, 0, fontSize);
        FontMetrics metrics = new JLabel().getFontMetrics(font);
        int width = (int)Math.round((double)metrics.stringWidth(text) * widthScale);
        int height = (int)Math.round((double)metrics.getMaxAscent() * heightScale);
        BufferedImage bi = new BufferedImage(width, height -= 4, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setFont(font);
        g2d.setColor(Color.black);
        g2d.drawString(text, 0, height);
        g2d.dispose();
        StringBuilder builder = new StringBuilder();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                builder.append(bi.getRGB(x, y) != 0 ? "1" : "0");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String convert(String text, double widthScale, double heightScale, int fontSize) {
        return StringToPoints.convert(text, widthScale, heightScale, "sanserif", fontSize);
    }

    public static String convert(String text, double widthScale, double heightScale) {
        return StringToPoints.convert(text, widthScale, heightScale, 12);
    }

    public static String convert(String text) {
        return StringToPoints.convert(text, 1.0, 1.0);
    }
}

