/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.yamlconfiguration.utils;

import java.util.Collection;
import wf.utils.java.file.yamlconfiguration.configuration.Config;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;

public class ConfigBuilder {
    private String path;
    private String resourcePath;
    private Collection<ConfigDefaultValue> defaultValues;
    private boolean autoSave = true;
    private int autoSaveSeconds = 300;
    private boolean autoSaveUnique = false;

    public ConfigBuilder setPath(String path) {
        this.path = path;
        if (this.resourcePath == null) {
            this.resourcePath = path;
        }
        return this;
    }

    public ConfigBuilder setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public ConfigBuilder setDefaultValues(Collection<ConfigDefaultValue> defaultValues) {
        this.defaultValues = defaultValues;
        return this;
    }

    public ConfigBuilder setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
        return this;
    }

    public ConfigBuilder setAutoSaveSeconds(int autoSaveSeconds) {
        this.autoSaveSeconds = autoSaveSeconds;
        return this;
    }

    public ConfigBuilder setAutoSaveUnique(boolean autoSaveUnique) {
        this.autoSaveUnique = autoSaveUnique;
        return this;
    }

    public Config build() {
        if (!this.autoSave) {
            return new Config(this.path, this.resourcePath, this.defaultValues);
        }
        return new Config(this.path, this.resourcePath, this.defaultValues, this.autoSaveSeconds, this.autoSaveUnique);
    }
}

