/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math.smooth.controller;

import java.util.HashMap;
import java.util.Map;
import wf.utils.java.math.smooth.SmoothTransform;
import wf.utils.java.math.smooth.controller.Item;

public class SmoothTransformEntity<T> {
    private Map<T, SmoothTransform> items;

    public SmoothTransformEntity() {
        this(new HashMap());
    }

    public SmoothTransformEntity(Map<T, SmoothTransform> mapTyped) {
        this.items = mapTyped;
    }

    public void setOrUpdateItem(T t, SmoothTransform transform) {
        SmoothTransform currentTransform = this.items.get(t);
        if (currentTransform == null) {
            this.items.put(t, transform);
        } else {
            currentTransform.setTo(transform.getTo());
            currentTransform.setDuration(transform.getDuration());
        }
    }

    public void addOrUpdateItem(T t, SmoothTransform transform) {
        SmoothTransform currentTransform = this.items.get(t);
        if (currentTransform == null) {
            this.items.put(t, transform);
        } else {
            currentTransform.setTo(currentTransform.getTo() + transform.getTo());
            currentTransform.setDuration(transform.getDuration());
        }
    }

    public double get(T t, boolean autoDelete) {
        SmoothTransform transform = this.items.get(t);
        if (transform == null) {
            return 0.0;
        }
        if (autoDelete && this.items.get(t).isEnd()) {
            this.items.remove(t);
        }
        return transform.get();
    }

    public double get(T t) {
        SmoothTransform transform = this.items.get(t);
        if (transform == null) {
            return 0.0;
        }
        if (this.items.get(t).isEnd()) {
            this.items.remove(t);
        }
        return transform.get();
    }

    public void setItem(T t, Item item) {
        this.items.put(t, item);
    }

    public Map<T, SmoothTransform> getItems() {
        return this.items;
    }

    public void setItems(Map<T, SmoothTransform> items) {
        this.items = items;
    }

    public String toString() {
        return "SmoothTransformEntity{items=" + this.items + '}';
    }
}

