/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.searches;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import wf.utils.java.algoritms.searches.SearchAlgorithm;

public class BinarySearch
implements SearchAlgorithm {
    @Override
    public <T extends Comparable<T>> int find(T[] array, T key) {
        return this.search((Comparable[])array, key, 0, array.length - 1);
    }

    private <T extends Comparable<T>> int search(T[] array, T key, int left, int right) {
        if (right < left) {
            return -1;
        }
        int median = left + right >>> 1;
        int comp = key.compareTo(array[median]);
        if (comp == 0) {
            return median;
        }
        if (comp < 0) {
            return this.search((Comparable[])array, (Comparable)key, left, median - 1);
        }
        return this.search((Comparable[])array, (Comparable)key, median + 1, right);
    }

    public static void main(String[] args) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int size = 100;
        int maxElement = 100000;
        Object[] integers = (Integer[])IntStream.generate(() -> r.nextInt(maxElement)).limit(size).sorted().boxed().toArray(Integer[]::new);
        int shouldBeFound = integers[((Random)r).nextInt(size - 1)];
        BinarySearch search = new BinarySearch();
        int atIndex = search.find((Comparable[])integers, Integer.valueOf(shouldBeFound));
        System.out.println(String.format("Should be found: %d. Found %d at index %d. An array length %d", shouldBeFound, integers[atIndex], atIndex, size));
        int toCheck = Arrays.binarySearch(integers, (Object)shouldBeFound);
        System.out.println(String.format("Found by system method at an index: %d. Is equal: %b", toCheck, toCheck == atIndex));
    }
}

