/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math.smooth;

import wf.utils.java.math.smooth.SmoothTransformFunctionType;

public class SmoothTransform {
    private long start;
    private double from;
    private double to;
    private long duration;
    private SmoothTransformFunction function;
    private double value;

    public SmoothTransform(double from, double to, long duration, SmoothTransformFunction function) {
        this.from = from;
        this.value = from;
        this.to = to;
        this.duration = duration;
        this.function = function;
        this.start = System.currentTimeMillis();
    }

    public SmoothTransform(double from, double to) {
        this.from = from;
        this.value = from;
        this.to = to;
        this.duration = 3000L;
        this.function = SmoothTransformFunctionType.LINEAR;
        this.start = System.currentTimeMillis();
    }

    public SmoothTransform(double from, double to, long duration) {
        this.from = from;
        this.value = from;
        this.to = to;
        this.duration = duration;
        this.function = SmoothTransformFunctionType.LINEAR;
        this.start = System.currentTimeMillis();
    }

    public SmoothTransform(double from, double to, SmoothTransformFunction function) {
        this.from = from;
        this.value = from;
        this.to = to;
        this.duration = 3000L;
        this.function = function;
        this.start = System.currentTimeMillis();
    }

    public double get() {
        this.update();
        return this.value;
    }

    public void reset() {
        this.value = this.from;
        this.start = System.currentTimeMillis();
    }

    public void update() {
        this.value = System.currentTimeMillis() - this.start >= this.duration ? this.to : this.from + this.function.get(((double)System.currentTimeMillis() - (double)this.start) / (double)this.duration) * (this.to - this.from);
    }

    public void setTo(double to) {
        this.from = this.get();
        this.start = System.currentTimeMillis();
        this.to = to;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public double getFrom() {
        return this.from;
    }

    public void setFrom(double from) {
        this.from = from;
    }

    public double getTo() {
        return this.to;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public SmoothTransformFunction getFunction() {
        return this.function;
    }

    public void setFunction(SmoothTransformFunction function) {
        this.function = function;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isEnd() {
        return Math.abs(this.value - this.to) < 1.0E-7;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return "SmoothTransform{start=" + this.start + ", from=" + this.from + ", to=" + this.to + ", duration=" + this.duration + ", function=" + this.function + ", value=" + this.value + '}';
    }

    public static interface SmoothTransformFunction {
        public double get(double var1);
    }
}

