/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.object;

import java.io.File;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import wf.utils.java.misc.Assert;
import wf.utils.java.misc.annotation.Nullable;
import wf.utils.java.object.ClassUtils;

public class ObjectUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class<?> ... declaredExceptions) {
        if (!ObjectUtils.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            Class<?>[] var2 = declaredExceptions;
            int var3 = declaredExceptions.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                Class<?> declaredException = var2[var4];
                if (!declaredException.isInstance(ex)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(@Nullable Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            return !optional.isPresent();
        }
        if (obj instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)obj;
            return charSequence.length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.isEmpty();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.isEmpty();
        }
        return false;
    }

    @Nullable
    public static Object unwrapOptional(@Nullable Object obj) {
        if (obj instanceof Optional) {
            if (!((Optional)obj).isPresent()) {
                return null;
            }
            Object result = ((Optional)obj).get();
            Assert.isTrue(!(result instanceof Optional), "Multi-level Optional usage not supported");
            return result;
        }
        return obj;
    }

    public static boolean containsElement(@Nullable Object[] array, Object element) {
        if (array == null) {
            return false;
        }
        Object[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            Object arrayEle = var2[var4];
            if (!ObjectUtils.nullSafeEquals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectUtils.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        Enum<?>[] var3 = enumValues;
        int var4 = enumValues.length;
        int var5 = 0;
        while (true) {
            if (var5 >= var4) {
                return false;
            }
            Enum<?> candidate = var3[var5];
            if (caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant)) break;
            ++var5;
        }
        return true;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        E[] var2 = enumValues;
        int var3 = enumValues.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            E candidate = var2[var4];
            if (!((Enum)candidate).toString().equalsIgnoreCase(constant)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Constant [" + constant + "] does not exist in enum type " + enumValues.getClass().getComponentType().getName());
    }

    public static <A, O extends A> A[] addObjectToArray(@Nullable A[] array, @Nullable O obj) {
        return ObjectUtils.addObjectToArray(array, obj, array != null ? array.length : 0);
    }

    public static <A, O extends A> A[] addObjectToArray(@Nullable A[] array, @Nullable O obj, int position) {
        Class componentType = Object.class;
        if (array != null) {
            componentType = array.getClass().getComponentType();
        } else if (obj != null) {
            componentType = obj.getClass();
        }
        int newArrayLength = array != null ? array.length + 1 : 1;
        Object[] newArray = (Object[])Array.newInstance(componentType, newArrayLength);
        if (array != null) {
            System.arraycopy(array, 0, newArray, 0, position);
            System.arraycopy(array, position, newArray, position + 1, array.length - position);
        }
        newArray[position] = obj;
        return newArray;
    }

    public static Object[] toObjectArray(@Nullable Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static boolean nullSafeEquals(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 != null) {
            if (o1.equals(o2)) {
                return true;
            }
            return o1.getClass().isArray() && o2.getClass().isArray() ? ObjectUtils.arrayEquals(o1, o2) : false;
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                Object[] objects = (Object[])obj;
                return ObjectUtils.nullSafeHashCode(objects);
            }
            if (obj instanceof boolean[]) {
                boolean[] booleans = (boolean[])obj;
                return ObjectUtils.nullSafeHashCode(booleans);
            }
            if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                return ObjectUtils.nullSafeHashCode(bytes);
            }
            if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                return ObjectUtils.nullSafeHashCode(chars);
            }
            if (obj instanceof double[]) {
                double[] doubles = (double[])obj;
                return ObjectUtils.nullSafeHashCode(doubles);
            }
            if (obj instanceof float[]) {
                float[] floats = (float[])obj;
                return ObjectUtils.nullSafeHashCode(floats);
            }
            if (obj instanceof int[]) {
                int[] ints = (int[])obj;
                return ObjectUtils.nullSafeHashCode(ints);
            }
            if (obj instanceof long[]) {
                long[] longs = (long[])obj;
                return ObjectUtils.nullSafeHashCode(longs);
            }
            if (obj instanceof short[]) {
                short[] shorts = (short[])obj;
                return ObjectUtils.nullSafeHashCode(shorts);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(@Nullable Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        Object[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            Object element = var2[var4];
            hash = 31 * hash + ObjectUtils.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        boolean[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            boolean element = var2[var4];
            hash = 31 * hash + Boolean.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        byte[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte element = var2[var4];
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        char[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            char element = var2[var4];
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        double[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            double element = var2[var4];
            hash = 31 * hash + Double.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        float[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            float element = var2[var4];
            hash = 31 * hash + Float.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            int element = var2[var4];
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        long[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            long element = var2[var4];
            hash = 31 * hash + Long.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        short[] var2 = array;
        int var3 = array.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            short element = var2[var4];
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static String identityToString(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String var10000 = obj.getClass().getName();
        return var10000 + "@" + ObjectUtils.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static String getDisplayString(@Nullable Object obj) {
        return obj == null ? "" : ObjectUtils.nullSafeToString(obj);
    }

    public static String nullSafeClassName(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : "null";
    }

    public static String nullSafeToString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            return ObjectUtils.nullSafeToString(objects);
        }
        if (obj instanceof boolean[]) {
            boolean[] booleans = (boolean[])obj;
            return ObjectUtils.nullSafeToString(booleans);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return ObjectUtils.nullSafeToString(bytes);
        }
        if (obj instanceof char[]) {
            char[] chars = (char[])obj;
            return ObjectUtils.nullSafeToString(chars);
        }
        if (obj instanceof double[]) {
            double[] doubles = (double[])obj;
            return ObjectUtils.nullSafeToString(doubles);
        }
        if (obj instanceof float[]) {
            float[] floats = (float[])obj;
            return ObjectUtils.nullSafeToString(floats);
        }
        if (obj instanceof int[]) {
            int[] ints = (int[])obj;
            return ObjectUtils.nullSafeToString(ints);
        }
        if (obj instanceof long[]) {
            long[] longs = (long[])obj;
            return ObjectUtils.nullSafeToString(longs);
        }
        if (obj instanceof short[]) {
            short[] shorts = (short[])obj;
            return ObjectUtils.nullSafeToString(shorts);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    public static String nullSafeToString(@Nullable Object[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        Object[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Object o = var3[var5];
            stringJoiner.add(String.valueOf(o));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable boolean[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        boolean[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            boolean b = var3[var5];
            stringJoiner.add(String.valueOf(b));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable byte[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        byte[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            byte b = var3[var5];
            stringJoiner.add(String.valueOf(b));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable char[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        char[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            char c = var3[var5];
            stringJoiner.add("'" + String.valueOf(c) + "'");
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable double[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        double[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            double d = var3[var5];
            stringJoiner.add(String.valueOf(d));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable float[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        float[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            float f = var3[var5];
            stringJoiner.add(String.valueOf(f));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable int[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        int[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            int i = var3[var5];
            stringJoiner.add(String.valueOf(i));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable long[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        long[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            long l = var3[var5];
            stringJoiner.add(String.valueOf(l));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable short[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        short[] var3 = array;
        int var4 = array.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            short s = var3[var5];
            stringJoiner.add(String.valueOf(s));
        }
        return stringJoiner.toString();
    }

    private static boolean isSimpleValueType(Class<?> type) {
        return Void.class != type && Void.TYPE != type && (ClassUtils.isPrimitiveOrWrapper(type) || Enum.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type) || ZoneId.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || Charset.class.isAssignableFrom(type) || Currency.class.isAssignableFrom(type) || InetAddress.class.isAssignableFrom(type) || URI.class == type || URL.class == type || UUID.class == type || Locale.class == type || Pattern.class == type || Class.class == type);
    }
}

