/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.object.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import wf.utils.java.data.list.ConcurrentReferenceHashMap;
import wf.utils.java.misc.Assert;
import wf.utils.java.misc.annotation.Nullable;

public class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic() && method.getDeclaringClass() != Object.class;
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);

    public static Object getValue(Object o, String s) {
        try {
            Field field = o.getClass().getDeclaredField(s);
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getValue(Object o, String s, Class<T> c) {
        try {
            Field field = o.getClass().getDeclaredField(s);
            field.setAccessible(true);
            return c.cast(field.get(o));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setValue(Object o, String s, Object value) {
        try {
            Field field = o.getClass().getDeclaredField(s);
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)ex;
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        if (ex instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)ex;
            throw runtimeException;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> ctor = clazz.getDeclaredConstructor(parameterTypes);
        ReflectionUtils.makeAccessible(ctor);
        return ctor;
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, EMPTY_CLASS_ARRAY);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            Method[] var5 = methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false);
            int var6 = methods.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                Method method = var5[var7];
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target) {
        return ReflectionUtils.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception var4) {
            ReflectionUtils.handleReflectionException(var4);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull((Object)method, "Method must not be null");
        Class<?>[] var3 = declaredExceptions = method.getExceptionTypes();
        int var4 = declaredExceptions.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Class<?> declaredException = var3[var5];
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        Method[] var3 = methods = ReflectionUtils.getDeclaredMethods(clazz, false);
        int var4 = methods.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Method method = var3[var5];
            try {
                mc.doWith(method);
                continue;
            }
            catch (IllegalAccessException var8) {
                String var10002 = method.getName();
                throw new IllegalStateException("Not allowed to access method '" + var10002 + "': " + var8);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, @Nullable MethodFilter mf) {
        if (mf != USER_DECLARED_METHODS || clazz != Object.class) {
            Method[] methods;
            Method[] var4 = methods = ReflectionUtils.getDeclaredMethods(clazz, false);
            int var5 = methods.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Method method = var4[var6];
                if (mf != null && !mf.matches(method)) continue;
                try {
                    mc.doWith(method);
                    continue;
                }
                catch (IllegalAccessException var9) {
                    String var10002 = method.getName();
                    throw new IllegalStateException("Not allowed to access method '" + var10002 + "': " + var9);
                }
            }
            if (clazz.getSuperclass() == null || mf == USER_DECLARED_METHODS && clazz.getSuperclass() == Object.class) {
                if (clazz.isInterface()) {
                    for (Class<?> superIfc : clazz.getInterfaces()) {
                        ReflectionUtils.doWithMethods(superIfc, mc, mf);
                    }
                }
            } else {
                ReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(20);
        Objects.requireNonNull(methods);
        ReflectionUtils.doWithMethods(leafClass, methods::add);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        return ReflectionUtils.getUniqueDeclaredMethods(leafClass, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass, @Nullable MethodFilter mf) {
        ArrayList methods = new ArrayList(20);
        ReflectionUtils.doWithMethods(leafClass, method -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods) {
                if (!method.getName().equals(existingMethod.getName()) || method.getParameterCount() != existingMethod.getParameterCount() || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                methods.add(method);
            }
        }, mf);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionUtils.getDeclaredMethods(clazz, true);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean defensive) {
        Assert.notNull(clazz, "Class must not be null");
        Method[] result = declaredMethodsCache.get(clazz);
        if (result == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> var6 = defaultMethods.iterator();
                    while (var6.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = var6.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                declaredMethodsCache.put(clazz, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable var8) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", var8);
            }
        }
        return result.length != 0 && defensive ? (Method[])result.clone() : result;
    }

    @Nullable
    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static boolean isEqualsMethod(@Nullable Method method) {
        return method != null && method.getParameterCount() == 1 && method.getName().equals("equals") && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(@Nullable Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(@Nullable Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("toString");
    }

    public static boolean isObjectMethod(@Nullable Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method) || ReflectionUtils.isHashCodeMethod(method) || ReflectionUtils.isToStringMethod(method));
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        int i;
        String name = renamedMethod.getName();
        if (!name.startsWith("CGLIB$")) {
            return false;
        }
        for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
        }
        return i > "CGLIB$".length() && i < name.length() - 1 && name.charAt(i) == '$';
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    @Nullable
    public static Field findField(Class<?> clazz, @Nullable String name, @Nullable Class<?> type) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            Field[] var5 = fields = ReflectionUtils.getDeclaredFields(searchType);
            int var6 = fields.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                Field field = var5[var7];
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, @Nullable Object target, @Nullable Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException var4) {
            ReflectionUtils.handleReflectionException(var4);
        }
    }

    @Nullable
    public static Object getField(Field field, @Nullable Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException var3) {
            ReflectionUtils.handleReflectionException(var3);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException var7) {
                String var10002 = field.getName();
                throw new IllegalStateException("Not allowed to access field '" + var10002 + "': " + var7);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, @Nullable FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            Field[] var5 = fields = ReflectionUtils.getDeclaredFields(targetClass);
            int var6 = fields.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                Field field = var5[var7];
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                    continue;
                }
                catch (IllegalAccessException var10) {
                    String var10002 = field.getName();
                    throw new IllegalStateException("Not allowed to access field '" + var10002 + "': " + var10);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] result = declaredFieldsCache.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, result.length == 0 ? EMPTY_FIELD_ARRAY : result);
            }
            catch (Throwable var3) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", var3);
            }
        }
        return result;
    }

    public static void shallowCopyFieldState(Object src, Object dest) {
        Assert.notNull(src, "Source for field copy cannot be null");
        Assert.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            String var10002 = dest.getClass().getName();
            throw new IllegalArgumentException("Destination class [" + var10002 + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), field -> {
            ReflectionUtils.makeAccessible(field);
            Object srcValue = field.get(src);
            field.set(dest, srcValue);
        }, COPYABLE_FIELDS);
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);

        default public FieldFilter and(FieldFilter next) {
            Assert.notNull((Object)next, "Next FieldFilter must not be null");
            return field -> this.matches(field) && next.matches(field);
        }
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);

        default public MethodFilter and(MethodFilter next) {
            Assert.notNull((Object)next, "Next MethodFilter must not be null");
            return method -> this.matches(method) && next.matches(method);
        }
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

