/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.algoritms.sorts;

import java.util.Arrays;
import java.util.List;

public final class SortUtils {
    static <T> boolean swap(T[] array, int idx, int idy) {
        T swap = array[idx];
        array[idx] = array[idy];
        array[idy] = swap;
        return true;
    }

    static <T extends Comparable<T>> boolean less(T v, T w) {
        return v.compareTo(w) < 0;
    }

    static <T extends Comparable<T>> boolean greater(T v, T w) {
        return v.compareTo(w) > 0;
    }

    static <T extends Comparable<T>> boolean greaterOrEqual(T v, T w) {
        return v.compareTo(w) >= 0;
    }

    static void print(List<?> toPrint) {
        toPrint.stream().map(Object::toString).map(str -> str + " ").forEach(System.out::print);
        System.out.println();
    }

    static void print(Object[] toPrint) {
        System.out.println(Arrays.toString(toPrint));
    }

    static <T extends Comparable<T>> void flip(T[] array, int left, int right) {
        while (left <= right) {
            SortUtils.swap(array, left++, right--);
        }
    }

    static <T extends Comparable<T>> boolean isSorted(T[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (!SortUtils.less(array[i], array[i - 1])) continue;
            return false;
        }
        return true;
    }

    static <T extends Comparable<T>> boolean isSorted(List<T> list) {
        for (int i = 1; i < list.size(); ++i) {
            if (!SortUtils.less((Comparable)list.get(i), (Comparable)list.get(i - 1))) continue;
            return false;
        }
        return true;
    }
}

