/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.data.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import wf.utils.java.data.set.ArraySet;

public class ArrayMap<K, V>
implements Map<K, V> {
    private final List<Map.Entry<K, V>> entries;

    public ArrayMap() {
        this.entries = new ArrayList<Map.Entry<K, V>>();
    }

    public ArrayMap(int size) {
        this.entries = new ArrayList<Map.Entry<K, V>>(size);
    }

    @Override
    public V get(Object key) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            V oldValue = entry.getValue();
            entry.setValue(value);
            return oldValue;
        }
        this.entries.add(new Entry<K, V>(key, value));
        return null;
    }

    @Override
    public V remove(Object key) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Map.Entry<K, V> entry = this.entries.get(i);
            if (!entry.getKey().equals(key)) continue;
            this.entries.remove(i);
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.entries.addAll((Collection)m.entrySet());
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return new ArraySet(this.entries.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    @Override
    public Collection<V> values() {
        return this.entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ArraySet<Map.Entry<K, V>>(this.entries);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

