/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.data.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import wf.utils.java.misc.annotation.Nullable;

public class SerializationUtils {
    @Nullable
    public static byte[] serialize(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException var7) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + object.getClass(), var7);
        }
        return baos.toByteArray();
    }

    @Deprecated
    @Nullable
    public static Object deserialize(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            Object var2;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                var2 = ois.readObject();
            }
            return var2;
        }
        catch (IOException var6) {
            throw new IllegalArgumentException("Failed to deserialize object", var6);
        }
        catch (ClassNotFoundException var7) {
            throw new IllegalStateException("Failed to deserialize object type", var7);
        }
    }

    public static <T extends Serializable> T clone(T object) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(object)));
    }
}

