/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.data.set;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import wf.utils.java.data.map.ArrayMap;

public class ArraySet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private final transient ArrayMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public ArraySet() {
        this.map = new ArrayMap();
    }

    public ArraySet(int initialCapacity) {
        this.map = new ArrayMap(initialCapacity);
    }

    public ArraySet(List<E> entries) {
        this(entries.size());
        this.addAll(entries);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

