/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.file.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class FileNewLinesListener {
    private Thread thread;

    public FileNewLinesListener(String path, Consumer<String> run) {
        this(path, run, "utf-8", 25L);
    }

    public FileNewLinesListener(String path, Consumer<String> run, String charSetName) {
        this(path, run, charSetName, 25L);
    }

    public FileNewLinesListener(final String path, final Consumer<String> run, final String charSetName, final long repeatTime) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]), charSetName));
                    reader.skip(Long.MAX_VALUE);
                    String line = reader.readLine();
                    while (true) {
                        if (line == null) {
                            Thread.sleep(repeatTime);
                        } else {
                            run.accept(line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public String toString() {
        return "FileNewLinesReader{thread=" + this.thread + '}';
    }
}

