/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import wf.utils.java.math.MathUtils;

public class MathEval {
    private static final HashMap<String, ExpressFunction> FUNCTIONS = new HashMap<String, ExpressFunction>(){
        {
            this.put("sqrt", new ExpressFunction(1, nums -> Math.sqrt((Double)nums.get(0))));
            this.put("sin", new ExpressFunction(1, nums -> Math.sin(Math.toRadians((Double)nums.get(0)))));
            this.put("cos", new ExpressFunction(1, nums -> Math.cos(Math.toRadians((Double)nums.get(0)))));
            this.put("tan", new ExpressFunction(1, nums -> Math.tan(Math.toRadians((Double)nums.get(0)))));
            this.put("ceil", new ExpressFunction(1, nums -> Math.ceil((Double)nums.get(0))));
            this.put("floor", new ExpressFunction(1, nums -> Math.floor((Double)nums.get(0))));
            this.put("asin", new ExpressFunction(1, nums -> Math.toDegrees(Math.asin((Double)nums.get(0)))));
            this.put("acos", new ExpressFunction(1, nums -> Math.toDegrees(Math.acos((Double)nums.get(0)))));
            this.put("round", new ExpressFunction(1, nums -> Math.round((Double)nums.get(0))));
            this.put("min", new ExpressFunction(-1, nums -> MathUtils.findMin(nums.stream().mapToDouble(d -> d).toArray())));
            this.put("max", new ExpressFunction(-1, nums -> MathUtils.findMax(nums.stream().mapToDouble(d -> d).toArray())));
            this.put("pow", new ExpressFunction(2, nums -> Math.pow((Double)nums.get(0), (Double)nums.get(1))));
        }
    };

    public static double eval(String expression) {
        return MathEval.eval(expression, true);
    }

    public static double eval(String expression, final boolean floatFix) {
        final String str = expression.toLowerCase();
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    if (!this.eat(41)) {
                        throw new RuntimeException("Missing ')'");
                    }
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else {
                    if (this.ch < 97 || this.ch > 122) throw new RuntimeException("Unexpected: " + (char)this.ch);
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    ExpressFunction function = (ExpressFunction)FUNCTIONS.get(func);
                    if (function == null) {
                        throw new RuntimeException("Unknown function: " + func);
                    }
                    if (!this.eat(40)) throw new RuntimeException("Missing '(' after function " + func);
                    ArrayList<Double> args = new ArrayList<Double>(2);
                    args.add(this.parseExpression());
                    while (this.eat(44)) {
                        args.add(this.parseExpression());
                    }
                    if (!this.eat(41)) {
                        throw new RuntimeException("Missing ')' after arguments to " + func);
                    }
                    if (function.getArgsCount() != -1 && function.getArgsCount() != args.size()) {
                        throw new RuntimeException("Invalid number of arguments for function " + func);
                    }
                    x = function.execute(args);
                }
                if (!this.eat(94)) return floatFix ? MathUtils.floatFix(x) : x;
                x = Math.pow(x, this.parseFactor());
                return floatFix ? MathUtils.floatFix(x) : x;
            }
        }.parse();
    }

    private static class ExpressFunction {
        private final int argsCount;
        private final Function<List<Double>, Double> function;

        public ExpressFunction(int argsCount, Function<List<Double>, Double> function) {
            this.argsCount = argsCount;
            this.function = function;
        }

        public int getArgsCount() {
            return this.argsCount;
        }

        public double execute(List<Double> args) {
            return this.function.apply(args);
        }
    }
}

