/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import sun.font.FontDesignMetrics;

public class SymbolPixels {
    public static BufferedImage drawImage(String text, int fontSize) {
        return SymbolPixels.drawImage(text, fontSize, Color.BLACK);
    }

    public static BufferedImage drawImage(String text, int fontSize, Color color) {
        Font font = new Font("Arial", 1, fontSize);
        FontDesignMetrics fontMetrics = FontDesignMetrics.getMetrics(font);
        AttributedString attributedText = new AttributedString(text);
        attributedText.addAttribute(TextAttribute.FONT, font);
        attributedText.addAttribute(TextAttribute.FOREGROUND, color);
        int height = fontSize - ((FontMetrics)fontMetrics).getDescent();
        int width = (int)fontMetrics.getStringBounds(text, null).getWidth() + 1;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.drawString(attributedText.getIterator(), 0, height);
        return image;
    }

    public static boolean[][] drawMatrix(String text, int fontSize) {
        BufferedImage image = SymbolPixels.drawImage(text, fontSize);
        boolean[][] pixels = new boolean[image.getWidth()][image.getHeight()];
        for (int w = 0; w < image.getWidth(); ++w) {
            for (int h = 0; h < image.getHeight(); ++h) {
                pixels[w][h] = SymbolPixels.isPainted(image.getRGB(w, h));
            }
        }
        return pixels;
    }

    public static boolean isPainted(int color) {
        return color != -1;
    }
}

