/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.object;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import wf.utils.java.console.ConsoleColor;
import wf.utils.java.values.DefaultDataType;

public class ObjectToString {
    public static String toString(Object object) {
        return ObjectToString.toString(object, false);
    }

    public static String toString(Object object, boolean colored) {
        if (!colored) {
            return ObjectToString.toString(object, null, 0, false, null);
        }
        return ConsoleColor.translateAlternateColorCodes(ObjectToString.toString(object, null, 0, true, null), '&');
    }

    private static String toString(Object object, String fieldName, int indentationLevel, boolean colored, Set<Object> objectSet) {
        StringBuilder builder = new StringBuilder();
        Field[] fields = ObjectToString.getAllFields(object.getClass());
        if (objectSet == null) {
            objectSet = Collections.newSetFromMap(new IdentityHashMap());
            objectSet.add(object);
        }
        if (fieldName == null) {
            builder.append(colored ? "&4" : "").append(object.getClass().getSimpleName());
        } else {
            builder.append(ObjectToString.getTypeOfClassOwn(object.getClass(), colored));
        }
        if (fieldName != null) {
            builder.append(fieldName);
        }
        builder.append(" ").append(ObjectToString.getOpenBracesSymbol(colored));
        if (fields.length != 0) {
            builder.append("\n");
        }
        for (Field field : fields) {
            builder.append(ObjectToString.getIndentation(indentationLevel + 1));
            builder.append(ObjectToString.fieldToString(object, field, indentationLevel + 1, colored, objectSet));
        }
        builder.append(fields.length == 0 ? " " : ObjectToString.getIndentation(indentationLevel));
        builder.append(ObjectToString.getCloseBracesSymbol(colored));
        if (fieldName != null) {
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String fieldToString(Object object, Field field, int indentationLevel, boolean colored, Set<Object> objectSet) {
        Object result;
        field.setAccessible(true);
        if (!field.isAccessible()) {
            return "";
        }
        field.setAccessible(true);
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            return ObjectToString.getFieldTypeOwn(field, colored) + ObjectToString.getFieldName(field, colored) + ObjectToString.getEqualsSymbol(colored) + ObjectToString.getNullSymbol(colored) + ObjectToString.getCommaSymbol(colored) + " \n";
        }
        if (DefaultDataType.isDefaultArray(result)) {
            return ObjectToString.getFieldType(field, colored) + ObjectToString.getFieldName(field, colored) + ObjectToString.getEqualsSymbol(colored) + (colored ? "&a" : "") + ObjectToString.defaultArrayToString((Object[])result, colored) + ObjectToString.getCommaSymbol(colored) + " \n";
        }
        if (DefaultDataType.isArray(result)) {
            return ObjectToString.getFieldTypeOwn(field, colored) + ObjectToString.getFieldName(field, colored) + ObjectToString.getEqualsSymbol(colored) + (colored ? "&a" : "") + ObjectToString.objectArrayToString((Object[])result, indentationLevel, colored, objectSet);
        }
        if (DefaultDataType.isDefaultType(result)) {
            return ObjectToString.getFieldType(field, colored) + ObjectToString.getFieldName(field, colored) + ObjectToString.getEqualsSymbol(colored) + (colored ? "&a" : "") + String.valueOf(result) + ObjectToString.getCommaSymbol(colored) + " \n";
        }
        if (objectSet.contains(result)) {
            return ObjectToString.getFieldTypeOwn(field, colored) + ObjectToString.getFieldName(field, colored) + ObjectToString.getEqualsSymbol(colored) + (colored ? "&a" : "") + "*..." + ObjectToString.getCommaSymbol(colored) + " \n";
        }
        objectSet.add(result);
        return ObjectToString.toString(result, ObjectToString.getFieldName(field, colored), indentationLevel, colored, objectSet);
    }

    private static String objectArrayToString(Object[] array, int indentationLevel, boolean colored, Set<Object> objectSet) {
        StringBuilder builder = new StringBuilder();
        builder.append(ObjectToString.getOpenSquareBracketSymbol(colored));
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object == null) {
                builder.append("\n");
                builder.append(ObjectToString.getIndentation(indentationLevel + 1)).append(ObjectToString.getNullSymbol(colored));
                if (i != array.length - 1) {
                    builder.append(ObjectToString.getCommaSymbol(colored));
                }
                if (i != array.length - 1) continue;
                builder.append("\n");
                continue;
            }
            if (DefaultDataType.isDefaultArray(object)) {
                builder.append("\n");
                builder.append(ObjectToString.getIndentation(indentationLevel + 1)).append(colored ? "&a" : "").append(ObjectToString.defaultArrayToString((Object[])object, colored));
                if (i != array.length - 1) {
                    builder.append(ObjectToString.getCommaSymbol(colored));
                }
                if (i != array.length - 1) continue;
                builder.append("\n");
                continue;
            }
            if (DefaultDataType.isArray(object)) {
                builder.append("\n");
                builder.append(colored ? "&a" : "").append(ObjectToString.objectArrayToString((Object[])object, indentationLevel, colored, objectSet));
                if (i != array.length - 1) {
                    builder.append(ObjectToString.getCommaSymbol(colored));
                }
                if (i != array.length - 1) continue;
                builder.append("\n");
                continue;
            }
            if (DefaultDataType.isDefaultType(object)) {
                builder.append(colored ? "&a" : "").append(String.valueOf(object));
                if (i == array.length - 1) continue;
                builder.append(ObjectToString.getCommaSymbol(colored)).append(" ");
                continue;
            }
            builder.append("\n");
            if (objectSet.contains(object)) {
                builder.append(ObjectToString.getIndentation(indentationLevel + 1)).append(colored ? "&a" : "").append("*...");
            } else {
                objectSet.add(object);
                builder.append(ObjectToString.getIndentation(indentationLevel + 1)).append(ObjectToString.toString(object, null, indentationLevel + 1, colored, objectSet));
            }
            if (i != array.length - 1) {
                builder.append(ObjectToString.getCommaSymbol(colored));
            }
            if (i != array.length - 1) continue;
            builder.append("\n");
        }
        if (builder.charAt(builder.length() - 1) == '\n') {
            builder.append(ObjectToString.getIndentation(indentationLevel)).append(ObjectToString.getCloseSquareBracketSymbol(colored));
        } else {
            builder.append(ObjectToString.getCloseSquareBracketSymbol(colored));
        }
        builder.append("\n");
        return builder.toString();
    }

    private static String defaultArrayToString(Object[] array, boolean colored) {
        StringBuilder builder = new StringBuilder();
        builder.append(ObjectToString.getOpenSquareBracketSymbol(colored));
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object == null) {
                builder.append(ObjectToString.getNullSymbol(colored));
            } else {
                builder.append(colored ? "&a" : "").append(String.valueOf(object));
            }
            if (i == array.length - 1) continue;
            builder.append(colored ? "&b," : ",");
        }
        builder.append(ObjectToString.getCloseSquareBracketSymbol(colored));
        return builder.toString();
    }

    private static String getIndentation(int indentationLevel) {
        if (indentationLevel == 0) {
            return "";
        }
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < indentationLevel; ++i) {
            indentation.append("    ");
        }
        return indentation.toString();
    }

    private static String getFieldName(Field field, boolean colored) {
        return (colored ? "&b" : "") + field.getName();
    }

    private static String getFieldType(Field field, boolean colored) {
        return ObjectToString.getTypeOfClass(field.getType(), colored);
    }

    private static String getFieldTypeOwn(Field field, boolean colored) {
        return ObjectToString.getTypeOfClassOwn(field.getType(), colored);
    }

    private static String getTypeOfClass(Class<?> clazz, boolean colored) {
        return ObjectToString.getOpenBracketSymbol(colored) + (colored ? "&7" : "") + clazz.getSimpleName() + ObjectToString.getCloseBracketSymbol(colored) + " ";
    }

    private static String getTypeOfClassOwn(Class<?> clazz, boolean colored) {
        return (colored ? "&4(" : "(") + (colored ? "&4" : "") + clazz.getSimpleName() + (colored ? "&4)" : ")") + " ";
    }

    private static String getEqualsSymbol(boolean colored) {
        return (colored ? "&9" : "") + " = ";
    }

    private static String getOpenBracketSymbol(boolean colored) {
        return (colored ? "&7" : "") + "(";
    }

    private static String getCloseBracketSymbol(boolean colored) {
        return (colored ? "&7" : "") + ")";
    }

    private static String getOpenBracesSymbol(boolean colored) {
        return (colored ? "&5" : "") + "{";
    }

    private static String getCloseBracesSymbol(boolean colored) {
        return (colored ? "&5" : "") + "}";
    }

    private static String getOpenSquareBracketSymbol(boolean colored) {
        return (colored ? "&8" : "") + "[";
    }

    private static String getCloseSquareBracketSymbol(boolean colored) {
        return (colored ? "&8" : "") + "]";
    }

    private static String getCommaSymbol(boolean colored) {
        return (colored ? "&6" : "") + ",";
    }

    private static String getNullSymbol(boolean colored) {
        return (colored ? "&a" : "") + "null";
    }

    private static Field[] getAllFields(Class<?> clazz) {
        HashSet fields = new HashSet();
        while (clazz != null) {
            Collections.addAll(fields, clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        fields.forEach(f -> f.setAccessible(true));
        return fields.toArray(new Field[0]);
    }
}

